/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.session;

import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.Genome;
import org.broad.igv.feature.GenomeManager;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackGroup;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.panel.DataPanel;
import org.broad.igv.ui.panel.DragEventManager;
import org.broad.igv.ui.panel.TrackPanelScrollPane;
import org.broad.igv.ui.util.MessageUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewContext {
    private static Logger log = Logger.getLogger(ViewContext.class);
    private static ViewContext instance = new ViewContext();
    private static NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
    private String genomeId;
    Genome genome;
    public int binsPerTile = 700;
    int dataPanelWidth = 700;
    private String chrName = "chrAll";
    private int minZoom;
    private int zoom = this.minZoom = 0;
    public static int maxZoom = 23;
    private int nTiles = 1;
    private double maxPixel;
    private double origin = 0.0;
    private double locationScale;
    private boolean locationScaleValid = false;
    private boolean stretched = false;
    public History history;
    static double log2 = Math.log(2.0);

    public static ViewContext getInstance() {
        return instance;
    }

    private ViewContext() {
        String lastChromosomeViewed = PreferenceManager.getInstance().getLastChromosomeViewed();
        this.chrName = lastChromosomeViewed == null || lastChromosomeViewed.trim().equals("") ? this.getHomeChr() : lastChromosomeViewed;
        this.history = new History(100);
    }

    public String getHomeChr() {
        return this.genome == null ? "All" : this.genome.getHomeChromosome();
    }

    private void computeMaxZoom() {
        if (this.genome != null && this.chrName != null && this.genome.getChromosome(this.chrName) != null) {
            if (this.chrName.equals("All")) {
                maxZoom = 0;
            } else {
                int chrLength = this.genome.getChromosome(this.chrName).getLength();
                maxZoom = (int)(Math.log((double)chrLength / 50.0) / log2) + 1;
            }
            if (this.zoom > maxZoom) {
                this.setZoom(maxZoom);
            }
        }
    }

    private void setZoom(int newZoom) {
        this.zoom = Math.min(maxZoom, newZoom);
        this.nTiles = (int)Math.pow(2.0, Math.max(this.minZoom, this.zoom));
        this.maxPixel = this.getTilesTimesBinsPerTile();
        this.invalidateLocationScale();
        if (IGVMainFrame.hasInstance()) {
            IGVMainFrame.getInstance().repaintStatusAndZoomSlider();
        }
    }

    public void incrementZoom(int increment) {
        this.zoomAndCenter(this.zoom + increment);
    }

    public void zoomAndCenterAdjusted(int newZoom) {
        this.zoomAndCenter(this.minZoom + newZoom);
    }

    public void zoomAndCenter(int newZoom) {
        double currentCenter = this.origin + (double)(this.dataPanelWidth / 2) * this.getScale();
        this.zoomTo(newZoom, currentCenter);
    }

    public void zoomTo(int newZoom, double newCenter) {
        if (this.chrName.equals("All")) {
            this.chrName = this.getHomeChr();
        }
        if (this.chrName.equals("All")) {
            this.jumpToChromosomeForGenomeLocation(newCenter);
            IGVMainFrame.getInstance().chromosomeChangeEvent();
        } else if (this.zoom != newZoom) {
            this.setZoom(newZoom);
            this.computeLocationScaleImmediately();
            double newLocationScale = this.getScale();
            double newOrigin = Math.round(newCenter - (double)(this.dataPanelWidth / 2) * newLocationScale);
            this.setOrigin(newOrigin);
        }
        this.recordHistory();
        DragEventManager.getInstance().dragStopped();
    }

    public void recordHistory() {
        this.history.push(this.getFormattedLocusString());
    }

    private void jumpToChromosomeForGenomeLocation(double locationMB) {
        double startMB = 0.0;
        for (String chr : this.getGenome().getChromosomeNames()) {
            double endMB = startMB + (double)this.getGenome().getChromosome(chr).getLength() / 1000.0;
            if (locationMB > startMB && locationMB <= endMB) {
                this.setChromosomeName(chr);
                break;
            }
            startMB = endMB;
        }
    }

    public void shiftOriginPixels(double delta) {
        double shiftBP = delta * this.getScale();
        this.setOrigin(this.origin + shiftBP);
    }

    public void snapToGrid() {
        this.setOrigin(Math.round(this.origin));
    }

    public void centerOnLocation(String chr, double chrLocation) {
        if (!this.chrName.equals(chr)) {
            this.chrName = chr;
            this.computeMaxZoom();
            if (this.zoom > maxZoom) {
                this.setZoom(maxZoom);
            }
        }
        double windowWidth = (double)this.dataPanelWidth * this.getScale() / 2.0;
        this.setOrigin(Math.round(chrLocation - windowWidth));
    }

    public void centerOnLocation(double chrLocation) {
        double windowWidth = (double)this.dataPanelWidth * this.getScale() / 2.0;
        this.setOrigin(Math.round(chrLocation - windowWidth));
        this.recordHistory();
    }

    public boolean windowAtEnd() {
        double windowLengthBP = (double)this.dataPanelWidth * this.getScale();
        return this.origin + windowLengthBP + 1.0 > (double)this.getChromosomeLength();
    }

    public void setOrigin(double newOrigin) {
        int windowLengthBP = (int)((double)this.dataPanelWidth * this.getScale());
        this.origin = PreferenceManager.getInstance().getSAMPreferences().isShowSoftClipped() ? Math.max(-1000.0, Math.min(newOrigin, (double)(this.getChromosomeLength() + 1000 - windowLengthBP))) : Math.max(0.0, Math.min(newOrigin, (double)(this.getChromosomeLength() - windowLengthBP)));
        for (TrackPanelScrollPane sp : IGVMainFrame.getInstance().getTrackManager().getTrackPanelScrollPanes()) {
            this.preloadTrackData(sp.getDataPanel());
        }
        if (this.locationScale < 10.0) {
            IGVMainFrame.getInstance().setStatusBarMessage(this.chrName + ":" + ((int)this.getCenter() + 1));
        }
        IGVMainFrame.getInstance().repaintDataAndHeaderPanels();
        IGVMainFrame.getInstance().repaintStatusAndZoomSlider();
    }

    public void jumpTo(String chr, int start, int end) {
        if (chr != null) {
            if (this.genome.getChromosome(chr) == null && !chr.contains("All")) {
                JOptionPane.showMessageDialog(IGVMainFrame.getInstance(), chr + " is not a valid chromosome.");
                return;
            }
            this.setChromosomeName(chr);
        }
        if (start >= 0) {
            int z = (int)(Math.log(this.getChromosomeLength() / (end - start)) / log2) + 1;
            if (z != this.zoom) {
                this.zoom = Math.min(maxZoom, Math.max(this.minZoom, z));
                this.nTiles = (int)Math.pow(2.0, this.zoom);
                this.maxPixel = this.getTilesTimesBinsPerTile();
            }
            int w = this.dataPanelWidth;
            this.setLocationScale((double)(end - start) / (double)w);
            this.origin = start;
        }
        for (TrackPanelScrollPane sp : IGVMainFrame.getInstance().getTrackManager().getTrackPanelScrollPanes()) {
            this.preloadTrackData(sp.getDataPanel());
        }
        if (log.isDebugEnabled()) {
            log.debug("Data panel width = " + this.dataPanelWidth);
            log.debug("New start = " + (int)this.getOrigin());
            log.debug("New end = " + (int)this.getEnd());
            log.debug("New center = " + (int)this.getCenter());
        }
        IGVMainFrame.getInstance().repaintDataAndHeaderPanels();
        IGVMainFrame.getInstance().repaintStatusAndZoomSlider();
    }

    public double getOrigin() {
        return this.origin;
    }

    public double getCenter() {
        return this.origin + this.getScale() * (double)this.dataPanelWidth / 2.0;
    }

    public double getEnd() {
        return this.origin + this.getScale() * (double)this.dataPanelWidth;
    }

    public int getZoom() {
        return this.zoom;
    }

    public int getMaxZoom() {
        return maxZoom;
    }

    public int getAdjustedZoom() {
        return this.zoom - this.minZoom;
    }

    public int getNTiles() {
        return this.nTiles;
    }

    public double getMaxPixel() {
        return this.maxPixel;
    }

    public void setDataPanel(DataPanel panel) {
        if (panel != null) {
            panel.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent e2) {
                    int w = e2.getComponent().getWidth();
                    if (w != ViewContext.this.dataPanelWidth) {
                        ViewContext.this.dataPanelWidth = w;
                        ViewContext.this.invalidateLocationScale();
                    }
                }
            });
        }
    }

    public void setChrName(String name) {
        this.setChromosomeName(name);
    }

    public void setChromosomeName(String name, boolean force) {
        if (this.chrName == null || !name.equals(this.chrName) || force) {
            this.chrName = name;
            this.origin = 0.0;
            this.setZoom(0);
            this.computeMaxZoom();
        }
    }

    public void setChromosomeName(String name) {
        this.setChromosomeName(name, false);
    }

    public String getChrName() {
        return this.chrName;
    }

    public String getNextChrName(String chr) {
        List<String> chrList = this.genome.getChromosomeNames();
        for (int i2 = 0; i2 < chrList.size() - 1; ++i2) {
            if (!chrList.get(i2).equals(chr)) continue;
            return chrList.get(i2 + 1);
        }
        return null;
    }

    public String getPrevChrName(String chr) {
        List<String> chrList = this.genome.getChromosomeNames();
        for (int i2 = chrList.size() - 1; i2 > 0; --i2) {
            if (!chrList.get(i2).equals(chr)) continue;
            return chrList.get(i2 - 1);
        }
        return null;
    }

    public int getDataPanelWidth() {
        return this.dataPanelWidth;
    }

    public double getScale() {
        if (this.locationScale == 0.0 || !this.locationScaleValid) {
            this.computeLocationScaleImmediately();
        }
        if (this.locationScale < 0.0) {
            System.err.println("Negative scale");
        }
        return this.locationScale;
    }

    public void invalidateLocationScale() {
        this.locationScaleValid = false;
    }

    public void computeLocationScaleImmediately() {
        if (this.genome != null) {
            this.computeMinZoom();
            double virtualPixelSize = this.getTilesTimesBinsPerTile();
            this.stretched = virtualPixelSize < (double)this.dataPanelWidth;
            double nPixel = Math.max(virtualPixelSize, (double)this.dataPanelWidth);
            this.setLocationScale((double)this.getChromosomeLength() / nPixel);
        }
    }

    private void computeMinZoom() {
        if (this.chrName.equals("All")) {
            this.minZoom = 0;
        } else {
            this.minZoom = Math.max(0, (int)(Math.log(this.dataPanelWidth / this.binsPerTile) / log2));
            if (this.zoom < this.minZoom) {
                this.zoom = this.minZoom;
                this.nTiles = (int)Math.pow(2.0, this.zoom);
                this.maxPixel = this.getTilesTimesBinsPerTile();
            }
        }
    }

    public double getChromosomePosition(int pixelIndex) {
        return this.origin + this.getScale() * (double)pixelIndex;
    }

    public int getPixelPosition(double chromosomePosition) {
        return (int)((chromosomePosition - this.origin) / this.getScale());
    }

    public Chromosome getChromosome() {
        if (this.genome == null) {
            log.error("Genome not loaded!");
            return null;
        }
        return this.genome.getChromosome(this.chrName);
    }

    public int getChromosomeLength() {
        if (this.genome == null) {
            return 1;
        }
        if (this.chrName.equals("All")) {
            return (int)(this.genome.getLength() / 1000L);
        }
        if (this.getChromosome() == null) {
            System.out.println("Null chromosome: " + this.chrName);
            if (this.genome == null) {
                return 1;
            }
            return this.genome.getChromosomes().iterator().next().getLength();
        }
        return this.getChromosome().getLength();
    }

    public String setGenomeId(String newGenome) {
        if (this.genomeId != null && !this.genomeId.equals(newGenome)) {
            this.history.clear();
        }
        if (log.isDebugEnabled()) {
            log.debug("Setting genome id: " + newGenome);
        }
        boolean startUp = this.genomeId == null;
        boolean loadFailed = false;
        this.genomeId = newGenome;
        if (!GenomeManager.getInstance().isGenomeLoaded(this.genomeId)) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("findGenomeAndLoad: " + this.genomeId);
                }
                GenomeManager.getInstance().findGenomeAndLoad(this.genomeId);
            }
            catch (IOException e2) {
                log.error("Error loading genome: " + this.genomeId, e2);
                loadFailed = true;
                MessageUtils.showMessage("Load of genome: " + this.genomeId + " failed.");
            }
        }
        this.genome = GenomeManager.getInstance().getGenome(this.genomeId);
        if (this.genome == null || loadFailed) {
            GenomeManager.GenomeListItem defaultDesc = GenomeManager.getInstance().getTopGenomeListItem();
            String msg = "Could not locate genome: " + this.genomeId + ".  Loading " + defaultDesc.getDisplayableName();
            MessageUtils.showMessage(msg);
            log.error("Could not locate genome: " + this.genomeId + ".  Loading " + defaultDesc.getDisplayableName());
            this.genomeId = defaultDesc.getId();
            try {
                if (log.isDebugEnabled()) {
                    log.debug("findGenomeAndLoad: " + this.genomeId);
                }
                GenomeManager.getInstance().findGenomeAndLoad(this.genomeId);
            }
            catch (IOException e3) {
                log.error("Error loading genome: " + this.genomeId, e3);
                MessageUtils.showMessage("<html>Load of genome: " + this.genomeId + " failed." + "<br>IGV is in an ustable state and will be closed." + "<br>Please report this error to igv-help@broadinstitute.org");
                System.exit(-1);
            }
            if (log.isDebugEnabled()) {
                log.debug("Get genome id");
            }
            this.genome = GenomeManager.getInstance().getGenome(this.genomeId);
            PreferenceManager.getInstance().setDefaultGenome(this.genomeId);
            this.setChrName(this.getHomeChr());
        } else if (!startUp) {
            this.setChrName(this.getHomeChr());
        }
        this.computeMaxZoom();
        this.invalidateLocationScale();
        if (!Globals.isHeadless()) {
            IGVMainFrame.getInstance().chromosomeChangeEvent();
        }
        return this.genomeId;
    }

    public void setGenomeIdHeadless(String newGenome) {
        this.genomeId = newGenome;
        this.genome = GenomeManager.getInstance().getGenome(this.genomeId);
    }

    public String getGenomeId() {
        return this.genomeId;
    }

    public Genome getGenome() {
        return this.genome;
    }

    public Collection<String> getChromosomeNames() {
        return this.genome.getChromosomeNames();
    }

    public boolean isStretched() {
        return this.stretched;
    }

    public double getTilesTimesBinsPerTile() {
        return (double)this.nTiles * (double)this.binsPerTile;
    }

    public String getFormattedLocusString() {
        if (this.zoom == 0) {
            return this.getChrName();
        }
        Range range = this.getCurrentRange();
        String startStr = numberFormat.format(range.getStart());
        String endStr = numberFormat.format(range.getEnd());
        String position = range.getChr() + ":" + startStr + "-" + endStr;
        return position;
    }

    public Range getCurrentRange() {
        int start = 0;
        int end = this.getDataPanelWidth();
        int startLoc = (int)this.getChromosomePosition(start) + 1;
        int endLoc = (int)this.getChromosomePosition(end);
        Range range = new Range(this.getChrName(), startLoc, endLoc);
        return range;
    }

    private void setLocationScale(double locationScale) {
        this.locationScale = locationScale;
        this.locationScaleValid = true;
    }

    private void preloadTrackData(DataPanel dp) {
        Rectangle visibleRect = dp.getVisibleRect();
        int start = (int)this.origin;
        int end = (int)((double)start + (double)dp.getWidth() * this.locationScale);
        int trackY = 0;
        Collection<TrackGroup> groups = dp.getTrackGroups();
        block0: for (TrackGroup group : groups) {
            if (!group.isVisible()) continue;
            if (groups.size() > 1) {
                trackY += 10;
            }
            for (Track track : group.getTracks()) {
                int trackHeight = track.getHeight();
                if (!(track instanceof AlignmentTrack) && visibleRect != null) {
                    if (trackY > visibleRect.y + visibleRect.height) continue block0;
                    if (trackY + trackHeight < visibleRect.y) {
                        trackY += trackHeight;
                        continue;
                    }
                }
                if (!track.isVisible()) continue;
                trackY += track.getHeight();
            }
        }
    }

    public List<String> getAllHistory() {
        return this.history.getAllHistory();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class History {
        int maxEntries = 100;
        int currPos = 0;
        LinkedList<String> activeStack;
        List<String> allHistory;

        History(int maxEntries) {
            this.maxEntries = maxEntries;
            this.activeStack = new LinkedList();
            this.allHistory = new ArrayList<String>();
        }

        public void push(String s) {
            log.debug("History: " + s);
            this.allHistory.add(s);
            while (this.currPos > 0) {
                this.activeStack.removeFirst();
                --this.currPos;
            }
            this.activeStack.addFirst(s);
        }

        public String back() {
            if (this.activeStack.size() == 0 || this.currPos >= this.activeStack.size() - 1) {
                return null;
            }
            ++this.currPos;
            return this.activeStack.get(this.currPos);
        }

        public String forward() {
            if (this.activeStack.size() == 0 || this.currPos == 0) {
                return null;
            }
            --this.currPos;
            this.printStack();
            return this.activeStack.get(this.currPos);
        }

        public String peekBack() {
            if (this.activeStack.size() == 0 || this.currPos + 1 >= this.activeStack.size()) {
                return null;
            }
            return this.activeStack.get(this.currPos + 1);
        }

        public String peekForward() {
            if (this.activeStack.size() == 0 || this.currPos - 1 < 0) {
                return null;
            }
            return this.activeStack.get(this.currPos - 1);
        }

        public void clear() {
            this.activeStack.clear();
            this.allHistory.clear();
            this.currPos = 0;
        }

        public void printStack() {
            System.out.println("curr pos=" + this.currPos);
            for (String s : this.activeStack) {
                System.out.println(s);
            }
            System.out.println();
        }

        public List<String> getAllHistory() {
            return this.allHistory;
        }
    }

    public static class Range {
        private String chr;
        private int start;
        private int end;

        public Range(String chr, int start, int end) {
            this.chr = chr;
            this.start = start;
            this.end = end;
        }

        public String getChr() {
            return this.chr;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }
    }
}

