/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.session;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.Feature;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.Genome;
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.session.ViewContext;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.RegionOfInterest;
import org.broad.igv.ui.TrackFilter;
import org.broad.igv.ui.util.MessageUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Session {
    private static Logger log = Logger.getLogger(Session.class);
    private static int versionNumber = 3;
    private String filePath;
    private String groupTracksBy;
    private ViewContext viewContext = ViewContext.getInstance();
    private TrackFilter filter;
    private HashMap<String, String> preferences;
    private HashMap<TrackType, ContinuousColorScale> colorScales;
    private Map<String, Collection<RegionOfInterest>> regionsOfInterest;

    public Session(String filePath) {
        log.debug("New session");
        this.filePath = filePath;
        this.regionsOfInterest = new LinkedHashMap<String, Collection<RegionOfInterest>>();
        this.preferences = new HashMap();
        this.colorScales = new HashMap();
    }

    public String getSessionVersion() {
        return String.valueOf(versionNumber);
    }

    public String getPath() {
        return this.filePath;
    }

    public void setPreference(String key, String value) {
        this.preferences.put(key, value);
    }

    public void setColorScale(TrackType trackType, ContinuousColorScale colorScale) {
        this.colorScales.put(trackType, colorScale);
    }

    public ContinuousColorScale getColorScale(TrackType trackType) {
        if (this.colorScales.containsKey((Object)trackType)) {
            return this.colorScales.get((Object)trackType);
        }
        return PreferenceManager.getInstance().getColorScale(trackType);
    }

    public boolean getDisplayOverlayTracks() {
        String key = "DISPLAY_OVERLAY_TRACKS_KEY";
        if (this.preferences.containsKey("DISPLAY_OVERLAY_TRACKS_KEY")) {
            try {
                return Boolean.parseBoolean(this.preferences.get("DISPLAY_OVERLAY_TRACKS_KEY"));
            }
            catch (Exception e2) {
                log.error("Error converting boolean preference DISPLAY_OVERLAY_TRACKS_KEY=" + this.preferences.get("DISPLAY_OVERLAY_TRACKS_KEY"));
            }
        }
        return PreferenceManager.getInstance().getDiplayOverlayTracks();
    }

    public boolean getColorOverlay() {
        String key = "COVER_OVERLAY_KEY";
        if (this.preferences.containsKey("COVER_OVERLAY_KEY")) {
            try {
                return Boolean.parseBoolean(this.preferences.get("COVER_OVERLAY_KEY"));
            }
            catch (Exception e2) {
                log.error("Error converting boolean preference COVER_OVERLAY_KEY=" + this.preferences.get("COVER_OVERLAY_KEY"));
            }
        }
        return PreferenceManager.getInstance().getColorOverlay();
    }

    public String getOverlayAttribute() {
        String key = "OVERLAY_ATTRIBUTE_KEY";
        if (this.preferences.containsKey("OVERLAY_ATTRIBUTE_KEY")) {
            return this.preferences.get("OVERLAY_ATTRIBUTE_KEY");
        }
        return PreferenceManager.getInstance().getOverlayAttribute();
    }

    public String getTrackAttributeName() {
        String key = "TRACK_ATTRIBUTE_NAME_KEY";
        if (this.preferences.containsKey("TRACK_ATTRIBUTE_NAME_KEY")) {
            return this.preferences.get("TRACK_ATTRIBUTE_NAME_KEY");
        }
        return PreferenceManager.getInstance().getTrackAttributeName();
    }

    public String getLocus() {
        ViewContext.Range range = this.getViewContext().getCurrentRange();
        if (range.getChr().equals("All")) {
            return "All";
        }
        String startStr = String.valueOf(range.getStart());
        String endStr = String.valueOf(range.getEnd());
        String position = range.getChr() + ":" + startStr + "-" + endStr;
        return position;
    }

    public void setLocus(String locusString) {
        try {
            Locus locus = Session.getLocus(locusString);
            if (locus == null) {
                this.getViewContext().setChrName(this.getViewContext().getHomeChr());
            } else {
                this.getViewContext().jumpTo(locus.chr, locus.start, locus.end);
            }
            this.viewContext.history.push(locusString);
        }
        catch (Exception e2) {
            MessageUtils.showMessage("Error setting locus string: " + locusString + " (" + e2.toString() + ")");
            log.error("Error setting locus string", e2);
        }
    }

    public TrackFilter getFilter() {
        return this.filter;
    }

    public void setFilter(TrackFilter filter) {
        this.filter = filter;
    }

    public String getGroupTracksBy() {
        return this.groupTracksBy;
    }

    public void setGroupTracksBy(String groupTracksBy) {
        this.groupTracksBy = groupTracksBy;
    }

    public ViewContext getViewContext() {
        return this.viewContext;
    }

    public Collection<RegionOfInterest> getRegionsOfInterest(String chr) {
        return this.regionsOfInterest.get(chr);
    }

    public Collection<RegionOfInterest> getAllRegionsOfInterest() {
        ArrayList<RegionOfInterest> roiList = new ArrayList<RegionOfInterest>();
        for (Collection<RegionOfInterest> roi : this.regionsOfInterest.values()) {
            roiList.addAll(roi);
        }
        return roiList;
    }

    public void addRegionOfInterestWithNoListeners(RegionOfInterest roi) {
        String chr = roi.getChr();
        Collection<RegionOfInterest> roiList = this.regionsOfInterest.get(chr);
        if (roiList == null) {
            roiList = new ArrayList<RegionOfInterest>();
            this.regionsOfInterest.put(chr, roiList);
        }
        roiList.add(roi);
    }

    public void clearRegionsOfInterest() {
        if (this.regionsOfInterest != null) {
            this.regionsOfInterest.clear();
        }
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    static Locus getLocus(String searchString) {
        if (searchString != null) {
            int colon = searchString.indexOf(":");
            if (colon > 0) {
                String chr = searchString.substring(0, colon);
                String posString = searchString.substring(colon).replace(":", "");
                int[] startEnd = Session.getStartEnd(posString);
                if (startEnd != null) {
                    return new Locus(chr, startEnd[0], startEnd[1]);
                }
            } else if (searchString.contains("-")) {
                int[] startEnd = Session.getStartEnd(searchString);
                if (startEnd != null) {
                    return new Locus(null, startEnd[0], startEnd[1]);
                }
            } else {
                Feature feature = FeatureDB.getFeature(searchString.toUpperCase().trim());
                if (feature != null) {
                    return new Locus(feature.getChr(), feature.getStart(), feature.getEnd());
                }
                Genome genome = IGVMainFrame.getInstance().getViewContext().getGenome();
                if (genome.getChromosome(searchString) != null) {
                    return new Locus(searchString, -1, -1);
                }
                return null;
            }
        }
        return null;
    }

    private static int[] getStartEnd(String posString) {
        try {
            String endString;
            String[] posTokens = posString.split("-");
            String startString = posTokens[0].replaceAll(",", "");
            int start = Math.max(0, Integer.parseInt(startString)) - 1;
            int end = start + 1;
            if (posTokens.length > 1) {
                endString = posTokens[1].replaceAll(",", "");
                end = Integer.parseInt(endString);
            }
            if (posTokens.length == 1 || end - start < 10) {
                int center = (start + end) / 2;
                start = center - 20;
                end = center + 20;
            } else {
                endString = posTokens[1].replaceAll(",", "");
                end = Integer.parseInt(endString);
            }
            return new int[]{Math.min(start, end), Math.max(start, end)};
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    static class Locus {
        String chr;
        int start;
        int end;

        Locus(String chr, int start, int end) {
            this.chr = chr;
            this.start = start;
            this.end = end;
        }
    }
}

