/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.util.CloseableIterator;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.reader.AlignmentQueryReader;
import org.broad.igv.sam.reader.WrappedIterator;
import org.broad.igv.ui.util.MessageUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BAMQueryReader
implements AlignmentQueryReader {
    SAMFileReader reader;
    SAMFileHeader header;

    public BAMQueryReader(File samFile) {
        try {
            this.reader = new SAMFileReader(samFile);
            this.reader.setValidationStringency(SAMFileReader.ValidationStringency.SILENT);
            this.loadHeader();
        }
        catch (Exception e2) {
            MessageUtils.showMessage("Error loading SAM header: " + e2.getMessage());
            e2.printStackTrace();
        }
    }

    @Override
    public SAMFileHeader getHeader() {
        if (this.header == null) {
            this.loadHeader();
        }
        return this.header;
    }

    @Override
    public Set<String> getSequenceNames() {
        SAMFileHeader header = this.getHeader();
        if (header == null) {
            return null;
        }
        HashSet<String> seqNames = new HashSet<String>();
        List<SAMSequenceRecord> records = header.getSequenceDictionary().getSequences();
        if (records.size() > 0) {
            for (SAMSequenceRecord rec : header.getSequenceDictionary().getSequences()) {
                String chr = rec.getSequenceName();
                seqNames.add(chr);
            }
        }
        return seqNames;
    }

    private void loadHeader() {
        this.header = this.reader.getFileHeader();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public boolean hasIndex() {
        return this.reader.hasIndex();
    }

    @Override
    public CloseableIterator<Alignment> query(String sequence, int start, int end, boolean contained) {
        return new WrappedIterator(this.reader.query(sequence, start, end, contained));
    }

    @Override
    public CloseableIterator<Alignment> iterator() {
        return new WrappedIterator(this.reader.iterator());
    }
}

