/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.Strand;
import org.broad.igv.sam.AbstractAlignment;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.track.WindowFunction;

public class GeraldAlignment
extends AbstractAlignment
implements Alignment {
    private boolean passedFilter;
    private String readSequence = null;
    private int start;
    private int end;

    public GeraldAlignment(String name) {
        this.readName = name;
    }

    public GeraldAlignment(GeraldAlignment alignment) {
        super(alignment);
    }

    public void setReads(String chr, int start, byte[] reads, byte[] qualities) {
        this.chr = chr;
        this.insertions = new AlignmentBlock[0];
        this.alignmentBlocks = new AlignmentBlock[1];
        this.alignmentBlocks[0] = new AlignmentBlock(start, reads, qualities);
        this.start = start;
        this.end = start + reads.length;
    }

    public String getReadSequence() {
        if (this.readSequence == null) {
            this.readSequence = new String(this.alignmentBlocks[0].getBases());
        }
        return this.readSequence;
    }

    public LocusScore copy() {
        return new GeraldAlignment(this);
    }

    public String getValueString(double position, WindowFunction windowFunction) {
        String str = super.getValueString(position, windowFunction);
        if (!this.passedFilter) {
            str = str + "<br>--------------<br>FAILED QUALITY FILTERING";
        }
        return str;
    }

    public String getCigarString() {
        return "*";
    }

    public AlignmentBlock[] getInsertions() {
        return this.insertions;
    }

    public boolean isProperPair() {
        return this.isPaired();
    }

    public int getAlignmentStart() {
        return this.alignmentBlocks[0].getStart();
    }

    public boolean isDuplicate() {
        return false;
    }

    public boolean isMapped() {
        return this.getChr() != null;
    }

    public boolean isPaired() {
        return this.getMate() != null;
    }

    public boolean isPassedFilter() {
        return this.passedFilter;
    }

    public void setPassedFilter(boolean passedFilter) {
        this.passedFilter = passedFilter;
    }

    public int getAlignmentEnd() {
        return this.end;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public String getSample() {
        return null;
    }

    public Strand getFragmentStrand(int read) {
        return Strand.NONE;
    }
}

