/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.awt.Color;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.Strand;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.AlignmentRenderer;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.track.WindowFunction;

public class FeatureWrappedAlignment
implements Alignment {
    String readName;
    String chr;
    int start;
    int end;
    AlignmentBlock[] blocks;
    Strand strand;
    BasicFeature f;

    public FeatureWrappedAlignment(BasicFeature f2) {
        this.readName = f2.getName();
        this.chr = f2.getChr();
        this.start = f2.getStart();
        this.end = f2.getEnd();
        this.strand = f2.getStrand();
        if (f2.getExonCount() > 0) {
            this.blocks = new AlignmentBlock[f2.getExonCount()];
            int i2 = 0;
            for (Exon exon : f2.getExons()) {
                int length = exon.getLength();
                byte[] seq = new byte[length];
                this.blocks[i2] = new AlignmentBlock(exon.getStart(), seq, seq);
                ++i2;
            }
        }
    }

    public String getReadName() {
        return this.readName;
    }

    public String getReadSequence() {
        return null;
    }

    public String getChromosome() {
        return this.chr;
    }

    public String getChr() {
        return this.chr;
    }

    public int getAlignmentStart() {
        return this.start;
    }

    public boolean contains(double location) {
        return location >= (double)this.start && location <= (double)this.getEnd();
    }

    public AlignmentBlock[] getAlignmentBlocks() {
        return this.blocks;
    }

    public AlignmentBlock[] getInsertions() {
        return null;
    }

    public String getCigarString() {
        return "*";
    }

    public int getInferredInsertSize() {
        return 0;
    }

    public int getMappingQuality() {
        return 255;
    }

    public ReadMate getMate() {
        return null;
    }

    public boolean isProperPair() {
        return true;
    }

    public boolean isMapped() {
        return true;
    }

    public boolean isPaired() {
        return false;
    }

    public boolean isNegativeStrand() {
        return this.strand == Strand.NEGATIVE;
    }

    public boolean isDuplicate() {
        return false;
    }

    public float getScore() {
        return 1.0f;
    }

    public void setConfidence(float confidence) {
    }

    public float getConfidence() {
        return 1.0f;
    }

    public LocusScore copy() {
        return this;
    }

    public String getValueString(double position, WindowFunction windowFunction) {
        return this.readName + "<br>Read length = " + (this.getEnd() - this.getStart());
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getAlignmentEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public byte getBase(double position) {
        return 0;
    }

    public byte getPhred(double position) {
        return 0;
    }

    public String getSample() {
        return null;
    }

    public String getReadGroup() {
        return null;
    }

    public Object getAttribute(String key) {
        return null;
    }

    public Strand getFragmentStrand(int readPair) {
        return Strand.NONE;
    }

    public void setMateSequence(String sequence) {
    }

    public String getPairOrientation() {
        return null;
    }

    public boolean isSmallInsert() {
        return false;
    }

    public boolean isVendorFailedRead() {
        return false;
    }

    public Color getDefaultColor() {
        return AlignmentRenderer.grey1;
    }

    public char[] getGapTypes() {
        return null;
    }
}

