/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.main;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.feature.Locus;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.TrackManager;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.RegionOfInterest;
import org.broad.igv.ui.WaitCursorManager;
import org.broad.igv.util.LRUCache;
import org.broad.igv.util.MacroSnapshotAction;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.RuntimeUtils;
import org.broad.igv.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandExecutor {
    private static Logger log = Logger.getLogger(CommandExecutor.class);

    private List<String> getArgs(String[] tokens) {
        ArrayList<String> args = new ArrayList<String>(tokens.length);
        for (String s : tokens) {
            if (s.trim().length() <= 0) continue;
            args.add(s.trim());
        }
        return args;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String execute(String command) {
        List<String> args = this.getArgs(StringUtils.breakQuotedString(command, ' ').toArray(new String[0]));
        String result = "OK";
        IGVMainFrame mainFrame = IGVMainFrame.getInstance();
        System.out.println();
        log.debug("Executing: " + command);
        try {
            String param3;
            if (args.size() <= 0) return "Empty command string";
            String cmd = args.get(0).toLowerCase();
            String param1 = args.size() > 1 ? args.get(1) : null;
            String param2 = args.size() > 2 ? args.get(2) : null;
            String string = param3 = args.size() > 3 ? args.get(3) : null;
            if (cmd.equals("echo")) {
                result = cmd;
            } else if (cmd.equals("goto")) {
                result = this.goto1(param1);
            } else if (cmd.equals("snapshotdirectory")) {
                result = this.setSnapshotDirectory(param1);
            } else if (cmd.equals("snapshot")) {
                String filename = param1;
                MacroSnapshotAction.doSnapshot(filename);
            } else if ((cmd.equals("loadfile") || cmd.equals("load")) && param1 != null) {
                result = this.load(param1);
            } else if (cmd.equals("hget") && args.size() > 3) {
                result = this.hget(param1, param2, param3);
            } else if (cmd.equals("genome") && args.size() > 1) {
                result = this.genome(param1);
            } else if (cmd.equals("new") || cmd.equals("reset") || cmd.equals("clear")) {
                mainFrame.createNewSession(null);
            } else if (cmd.equals("sort")) {
                this.sort(param1, param2, param3);
            } else if (cmd.equals("collapse")) {
                String trackName = param1 == null ? null : param1.replace("\"", "").replace("'", "");
                this.collapse(trackName);
            } else if (cmd.equals("expand")) {
                String trackName = param1 == null ? null : param1.replace("\"", "").replace("'", "");
                this.expand(trackName);
            } else if (cmd.equals("tweakdivider")) {
                IGVMainFrame.getInstance().tweakPanelDivider();
            } else if (cmd.equals("exit")) {
                System.exit(0);
            } else {
                log.error("UNKOWN COMMAND: " + command);
                return "UNKOWN COMMAND: " + command;
            }
            IGVMainFrame.getInstance().doRefresh();
            if (RuntimeUtils.getAvailableMemoryFraction() < 0.5) {
                log.debug("Clearing caches");
                LRUCache.clearCaches();
            }
            log.debug("Finished execution: " + command + "  sleeping ....");
            Thread.sleep(2000L);
            log.debug("Finished sleeping");
        }
        catch (Exception e2) {
            log.error("Could not Parse Command", e2);
            return "ERROR Could not Parse Command: " + e2.toString();
        }
        log.info(result);
        return result;
    }

    private String genome(String param1) {
        if (param1 == null) {
            return "ERROR missing genome parameter";
        }
        String genomeID = param1;
        IGVMainFrame.getInstance().selectGenomeFromList(genomeID);
        String result = "OK";
        return result;
    }

    private String hget(String param1, String param2, String param3) {
        String fileString = param1;
        String locusString = param2;
        String mergeValue = param3;
        boolean merge = mergeValue != null && mergeValue.equalsIgnoreCase("true");
        String result = this.loadFiles(fileString, locusString, merge);
        return result;
    }

    private String load(String param1) {
        if (param1 == null) {
            return "ERROR: missing path parameter";
        }
        String fileString = param1.replace("\"", "").replace("'", "");
        return this.loadFiles(fileString, null, true);
    }

    private String setSnapshotDirectory(String param1) {
        String result;
        if (param1 == null) {
            return "ERROR: missing directory parameter";
        }
        File parentDir = new File(param1);
        if (parentDir.exists()) {
            MacroSnapshotAction.setOutputDirectory(param1);
            result = "OK";
        } else {
            result = "ERROR: directory: " + param1 + " does not exist";
        }
        return result;
    }

    private String goto1(String param1) {
        if (param1 == null) {
            return "ERROR: missing locus parameter";
        }
        String locus = param1;
        IGVMainFrame.getInstance().goToLocus(locus);
        return "OK";
    }

    private void collapse(String trackName) {
        if (trackName == null) {
            IGVMainFrame.getInstance().getTrackManager().collapseTracks();
        } else {
            IGVMainFrame.getInstance().getTrackManager().collapseTrack(trackName);
        }
        IGVMainFrame.getInstance().repaintDataPanels();
    }

    private void expand(String trackName) {
        if (trackName == null) {
            IGVMainFrame.getInstance().getTrackManager().expandTracks();
        } else {
            IGVMainFrame.getInstance().getTrackManager().expandTrack(trackName);
        }
        IGVMainFrame.getInstance().repaintDataPanels();
    }

    private void sort(String sortArg, String locusString, String param3) {
        TrackManager tm = IGVMainFrame.getInstance().getTrackManager();
        RegionScoreType regionSortOption = CommandExecutor.getRegionSortOption(sortArg);
        if (regionSortOption != null) {
            Locus locus;
            RegionOfInterest roi = null;
            if (locusString != null && (locus = new Locus(locusString)).isValid()) {
                roi = new RegionOfInterest(locus.getChr(), locus.getStart(), locus.getEnd(), "");
            }
            tm.sortByRegionScore(roi, regionSortOption);
        } else {
            Double location = null;
            if (param3 != null) {
                try {
                    location = new Double(param3);
                }
                catch (NumberFormatException e2) {
                    log.info("Unexpected sort location argument: " + param3);
                }
            }
            if (location == null) {
                tm.sortAlignmentTracks(CommandExecutor.getAlignmentSortOption(sortArg));
            } else {
                tm.sortAlignmentTracks(CommandExecutor.getAlignmentSortOption(sortArg), location);
            }
        }
        IGVMainFrame.getInstance().repaintDataPanels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadFiles(String fileString, String locus, boolean merge) {
        log.debug("Run load files");
        WaitCursorManager.CursorToken token = null;
        try {
            token = WaitCursorManager.showWaitCursor();
            String[] files = fileString.split(",");
            ArrayList<ResourceLocator> fileLocators = new ArrayList<ResourceLocator>();
            ArrayList<String> sessionPaths = new ArrayList<String>();
            if (!merge) {
                IGVMainFrame.getInstance().createNewSession(null);
            }
            for (String f2 : files) {
                if (f2.endsWith(".xml")) {
                    sessionPaths.add(f2);
                    continue;
                }
                ResourceLocator rl = new ResourceLocator(f2);
                fileLocators.add(rl);
            }
            for (String sessionPath : sessionPaths) {
                InputStream is = null;
                try {
                    is = ParsingUtils.openInputStream(new ResourceLocator(sessionPath));
                    IGVMainFrame.getInstance().doRestoreSession(is, sessionPath, locus, merge);
                }
                catch (IOException e2) {
                    log.error(e2.getMessage(), e2);
                }
                finally {
                    if (is == null) continue;
                    try {
                        is.close();
                    }
                    catch (IOException e3) {
                        log.error(e3.getMessage(), e3);
                    }
                }
            }
            IGVMainFrame.getInstance().getTrackManager().loadResources(fileLocators);
            if (locus != null) {
                IGVMainFrame.getInstance().goToLocus(locus);
            }
        }
        finally {
            WaitCursorManager.removeWaitCursor(token);
        }
        return "OK";
    }

    private static RegionScoreType getRegionSortOption(String str) {
        if (str == null) {
            return null;
        }
        String option = str.toUpperCase();
        try {
            return RegionScoreType.valueOf(option);
        }
        catch (Exception e2) {
            return null;
        }
    }

    private static AlignmentTrack.SortOption getAlignmentSortOption(String str) {
        String option = str.toLowerCase();
        if (str == null || option.equals("base")) {
            return AlignmentTrack.SortOption.NUCELOTIDE;
        }
        if (option.equals("strand")) {
            return AlignmentTrack.SortOption.STRAND;
        }
        if (option.equals("start") || option.equals("position")) {
            return AlignmentTrack.SortOption.START;
        }
        if (option.equals("quality")) {
            return AlignmentTrack.SortOption.QUALITY;
        }
        if (option.equals("sample")) {
            return AlignmentTrack.SortOption.SAMPLE;
        }
        if (option.equals("readGroup") || option.equals("read_group")) {
            return AlignmentTrack.SortOption.READ_GROUP;
        }
        return AlignmentTrack.SortOption.NUCELOTIDE;
    }
}

