/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.main;

import java.io.BufferedReader;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.main.CommandExecutor;
import org.broad.igv.ui.WaitCursorManager;
import org.broad.igv.util.NamedRunnable;
import org.broad.igv.util.ParsingUtils;

public class BatchRunner
implements NamedRunnable {
    private static Logger log = Logger.getLogger(BatchRunner.class);
    String inputFile;

    public BatchRunner(String inputFile) {
        this.inputFile = inputFile;
    }

    public String getName() {
        return "batchExecution";
    }

    public void run() {
        CommandExecutor cmdExe = new CommandExecutor();
        Globals.setSuppress(true);
        Globals.batch = true;
        WaitCursorManager.CursorToken cursorToken = null;
        BufferedReader reader = null;
        try {
            String inLine;
            cursorToken = WaitCursorManager.showWaitCursor();
            reader = ParsingUtils.openBufferedReader(this.inputFile);
            while ((inLine = reader.readLine()) != null) {
                if (inLine.startsWith("#") || inLine.startsWith("//")) continue;
                log.info("Executing Command: " + inLine);
                cmdExe.execute(inLine);
            }
        }
        catch (IOException ioe) {
            throw new DataLoadException(ioe.getMessage(), this.inputFile);
        }
        finally {
            Globals.setSuppress(false);
            Globals.batch = false;
            if (cursorToken != null) {
                WaitCursorManager.removeWaitCursor(cursorToken);
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
    }
}

