/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.maf;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.maf.MAFLocalReader;
import org.broad.igv.maf.MAFReader;
import org.broad.igv.maf.MAFRemoteReader;
import org.broad.igv.maf.MAFTile;
import org.broad.igv.maf.MAFUtils;
import org.broad.igv.ui.WaitCursorManager;
import org.broad.igv.util.LRUCache;
import org.broad.igv.util.ResourceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MAFManager {
    private static Logger log = Logger.getLogger(MAFManager.class);
    public static String[] species = new String[]{"panTro2", "gorGor1", "ponAbe2", "rheMac2", "calJac1", "tarSyr1", "micMur1", "otoGar1", "tupBel1", "mm9", "rn4", "dipOrd1", "cavPor3", "speTri1", "oryCun1", "ochPri2", "vicPac1", "turTru1", "bosTau4", "equCab2", "felCat3", "canFam2", "myoLuc1", "pteVam1", "eriEur1", "sorAra1", "loxAfr2", "proCap1", "echTel1", "dasNov2", "choHof1", "monDom4", "ornAna1", "galGal3", "taeGut1", "anoCar1", "xenTro2", "tetNig1", "fr2", "gasAcu1", "oryLat28", "danRer5", "petMar1"};
    public static Properties speciesNames;
    private int tileSize = 500;
    LRUCache<String, MAFTile> tileCache = new LRUCache(this, 10);
    private List<String> selectedSpecies;
    private List<String> allSpecies;
    MAFReader reader;
    static MAFManager instance;
    String refId;

    public MAFManager(ResourceLocator locator) {
        if (speciesNames == null) {
            this.loadNames();
        }
        if (locator.isLocal()) {
            this.reader = new MAFLocalReader(locator.getPath());
            this.allSpecies = ((MAFLocalReader)this.reader).getSequenceIds();
            this.selectedSpecies = this.allSpecies.subList(1, this.allSpecies.size());
            this.refId = this.allSpecies.get(0);
        } else {
            this.reader = new MAFRemoteReader(locator);
            this.setSelectedSpecies(PreferenceManager.getInstance().getMafSpecies());
            this.refId = "hg18";
        }
    }

    private void loadNames() {
        try {
            InputStream is = MAFUtils.class.getResourceAsStream("species.properties");
            speciesNames = new Properties();
            speciesNames.load(is);
            is.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public String getSpeciesName(String speciesId) {
        return speciesNames.getProperty(speciesId);
    }

    public MAFTile[] getTiles(String chr, int start, int end) {
        int startTile = start / this.tileSize;
        int endTile = end / this.tileSize;
        MAFTile[] tiles = new MAFTile[endTile - startTile + 1];
        for (int i2 = startTile; i2 <= endTile; ++i2) {
            tiles[i2 - startTile] = this.getTile(chr, i2);
        }
        return tiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MAFTile getTile(String chr, int tileNo) {
        String key = MAFManager.getKey(chr, tileNo);
        MAFTile tile = this.tileCache.get(key);
        if (tile == null) {
            WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
            try {
                int start = tileNo * this.tileSize;
                int end = start + this.tileSize + 1;
                tile = this.reader.loadTile(chr, start, end, this.allSpecies);
                this.tileCache.put(key, tile);
            }
            finally {
                WaitCursorManager.removeWaitCursor(token);
            }
        }
        return tile;
    }

    static String getKey(String chr, int tileNo) {
        return chr + tileNo;
    }

    public List<String> getSelectedSpecies() {
        return this.selectedSpecies;
    }

    public void setSelectedSpecies(List<String> selectedSpecies) {
        this.selectedSpecies = selectedSpecies;
        this.allSpecies = new ArrayList<String>(selectedSpecies);
        this.allSpecies.add(0, "hg18");
    }
}

