/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.maf;

import edu.mit.broad.prodinfo.multiplealignment.MAFAlignment;
import edu.mit.broad.prodinfo.multiplealignment.MAFIO;
import edu.mit.broad.prodinfo.multiplealignment.MultipleAlignment;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.maf.MAFReader;
import org.broad.igv.maf.MAFTile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MAFLocalReader
implements MAFReader {
    private static Logger log = Logger.getLogger(MAFLocalReader.class);
    public static String mafFile;
    MAFIO mafIO;
    List<String> sequenceIds;

    public MAFLocalReader(String mafFileName) {
        mafFile = mafFileName;
        try {
            this.mafIO = new MAFIO(mafFile, false);
            MAFAlignment maf = this.mafIO.load(mafFile);
            this.sequenceIds = maf.getAlignedSequenceIds();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public List<String> getSequenceIds() {
        return this.sequenceIds;
    }

    @Override
    public MAFTile loadTile(String seq, int start, int end, List<String> species) {
        try {
            MAFAlignment maf = this.mafIO.load(species, start, end);
            if (maf.isEmpty()) {
                return null;
            }
            MultipleAlignment.AlignedSequence refSeq = maf.getAlignedSequences().get(0);
            int[] gapAdjustedCoordinates = new int[end - start];
            for (int i2 = start; i2 < end; ++i2) {
                int idx = i2 - start;
                gapAdjustedCoordinates[idx] = refSeq.getGapAdjustedCoordinate(idx);
            }
            HashMap<String, String> bases = new HashMap<String, String>();
            for (String seqId : maf.getAlignedSequenceIds()) {
                bases.put(seqId, maf.getAlignedSequence(seqId).getSequenceBases());
            }
            return new MAFTile(start, end, bases, gapAdjustedCoordinates, refSeq.getId());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.mafIO.destroyFileHandle();
    }
}

