/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.exceptions;

public class ParserException
extends RuntimeException {
    private long lineNumber = -1L;
    private String line;

    public ParserException(String message, long lineNumber) {
        super(message);
        this.setLineNumber(lineNumber);
    }

    public ParserException(String message, long lineNumber, String line) {
        super(message);
        this.setLineNumber(lineNumber);
        this.setLine(line);
    }

    public ParserException(String message, Throwable th, long lineNumber) {
        super(message, th);
        this.setLineNumber(lineNumber);
    }

    public ParserException(String message, Throwable th, long lineNumber, String line) {
        super(message, th);
        this.setLineNumber(lineNumber);
        this.setLine(line);
    }

    public void setLineNumber(long lineNumber) {
        this.lineNumber = lineNumber;
    }

    public void setLine(String line) {
        if (line != null) {
            this.line = line;
            if (line.length() > 500) {
                this.line = line.substring(0, 500);
            }
        }
    }

    public String getMessage() {
        String message = super.getMessage();
        if (message == null) {
            message = "";
        }
        if (this.getCause() != null) {
            if (this.line != null) {
                return "Failed to parse line " + this.lineNumber + ":\n" + "Cause\n  " + this.getCause().getClass().getSimpleName() + ": " + message;
            }
            return "Failed to parse line " + this.lineNumber + ":\n" + "\t" + this.line + "\n" + "Cause\n  " + this.getCause().getClass().getSimpleName() + ": " + message;
        }
        if (this.line != null) {
            return "Failed to parse line " + this.lineNumber + ":\n" + "\t" + this.line + "\n" + "\n  " + message;
        }
        return "Failed to parse line " + this.lineNumber + ":\n" + "\n  " + message;
    }
}

