/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.seg;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;
import org.broad.igv.data.seg.SegmentedAsciiDataSet;
import org.broad.igv.data.seg.SegmentedChromosomeData;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.session.ViewContext;
import org.broad.igv.track.TrackType;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SegmentedDataWriter {
    private static Logger log = Logger.getLogger(SegmentedDataWriter.class);
    private boolean compress = true;
    SegmentedAsciiDataSet dataset;
    String rootNodeName;
    File outputFile;
    TrackType trackType;

    public SegmentedDataWriter(SegmentedAsciiDataSet dataset, File outputFile) {
        this(dataset, outputFile, false, TrackType.COPY_NUMBER);
    }

    public SegmentedDataWriter(SegmentedAsciiDataSet dataset, File outputFile, boolean compress, TrackType type) {
        this.dataset = dataset;
        this.compress = compress;
        this.outputFile = outputFile;
        this.rootNodeName = "data";
        this.trackType = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeContents() {
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(new FileOutputStream(this.outputFile));
            List<String> samples = this.dataset.getDataHeadings();
            String[] sampleArray = samples.toArray(new String[0]);
            Set<String> chromosomes = this.dataset.getChromosomes();
            ArrayList<String> attributes = new ArrayList<String>();
            attributes.add("type=" + this.trackType.toString());
            attributes.add("logNormalized=" + this.dataset.isLogNormalized());
            this.writeStrings("attributes.txt", attributes, zos);
            this.writeStrings("samples.txt", samples, zos);
            this.writeStrings("chromosomes.txt", chromosomes, zos);
            ArrayList<String> tmp = new ArrayList<String>(this.dataset.getChromosomes());
            tmp.add("All");
            for (String chr : tmp) {
                HashMap<String, int[]> starts = new HashMap<String, int[]>();
                HashMap<String, int[]> ends = new HashMap<String, int[]>();
                HashMap<String, float[]> values = new HashMap<String, float[]>();
                for (String sample : samples) {
                    List<LocusScore> segments = chr.equals("All") ? this.dataset.getWholeGenomeScores(sample) : this.dataset.getSegments(sample, chr);
                    int nPts = segments == null ? 0 : segments.size();
                    int[] s = new int[nPts];
                    int[] e2 = new int[nPts];
                    float[] v = new float[nPts];
                    for (int i2 = 0; i2 < nPts; ++i2) {
                        s[i2] = segments.get(i2).getStart();
                        e2[i2] = segments.get(i2).getEnd();
                        v[i2] = segments.get(i2).getScore();
                    }
                    starts.put(sample, s);
                    ends.put(sample, e2);
                    values.put(sample, v);
                }
                SegmentedChromosomeData cd = new SegmentedChromosomeData(sampleArray, starts, ends, values);
                this.writeChromsomeData(chr, cd, zos);
            }
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        finally {
            try {
                zos.close();
            }
            catch (IOException e4) {
                e4.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStrings(String filename, Collection<String> strings, ZipOutputStream zos) {
        try {
            StringBuffer buff = new StringBuffer();
            for (String s : strings) {
                buff.append(s);
                buff.append('\n');
            }
            byte[] bytes = buff.toString().getBytes();
            String entryName = this.rootNodeName + "/" + filename;
            Utilities.createZipEntry(entryName, bytes, zos, this.compress);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeChromsomeData(String chr, SegmentedChromosomeData cd, ZipOutputStream zos) {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream(1000);
            BufferedOutputStream bos = new BufferedOutputStream(bytes);
            cd.serialize(bytes);
            bos.close();
            byte[] byteArray = bytes.toByteArray();
            String entryName = this.rootNodeName + "/" + chr + ".bin";
            Utilities.createZipEntry(entryName, byteArray, zos, this.compress);
        }
        catch (IOException ex) {
            log.error("Error writing segments", ex);
        }
    }

    public static void main(String[] args) {
        String inputFile = null;
        String outputFile = null;
        String genomeId = null;
        boolean compress = true;
        TrackType trackType = TrackType.COPY_NUMBER;
        if (args.length > 2) {
            inputFile = args[0].trim();
            outputFile = args[1].trim();
            genomeId = args[2].trim();
        } else {
            System.out.println("Arguments: inputFile  outputFile  genomeId  [track type (optional)");
            System.exit(-1);
        }
        if (args.length > 3) {
            try {
                trackType = TrackType.valueOf(args[3].trim());
            }
            catch (Exception e2) {
                System.out.println("Unknown track type: " + args[3]);
            }
        }
        ViewContext.getInstance().setGenomeId(genomeId);
        SegmentedAsciiDataSet ds = new SegmentedAsciiDataSet(new ResourceLocator(inputFile));
        SegmentedDataWriter writer = new SegmentedDataWriter(ds, new File(outputFile), compress, trackType);
        writer.writeContents();
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }
}

