/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.seg;

import org.broad.igv.feature.LocusScore;
import org.broad.igv.track.WindowFunction;

public class Segment
implements LocusScore {
    private int extendedStart = -1;
    private int extendedEnd = -1;
    private int start;
    private int end;
    private float score;
    private int snpCount;

    public Segment(int start, int end, float score) {
        this(start, end, score, 0);
    }

    public Segment(int start, int end, float score, int snpCount) {
        this.start = start;
        this.end = end;
        if (this.extendedStart < 0) {
            this.extendedStart = start;
        }
        if (this.extendedEnd < 0) {
            this.extendedEnd = end;
        }
        this.score = score;
        this.snpCount = snpCount;
    }

    public Segment(int start, int origStart, int end, int origEnd, float score, int snpCount) {
        this.start = start;
        this.end = end;
        this.extendedStart = origStart;
        this.extendedEnd = origEnd;
        this.score = score;
        this.snpCount = snpCount;
    }

    public Segment copy() {
        return new Segment(this.start, this.extendedStart, this.end, this.extendedEnd, this.score, this.snpCount);
    }

    public String getChr() {
        return null;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public float getScore() {
        return this.score;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public void setConfidence(float confidence) {
    }

    public float getConfidence() {
        return 1.0f;
    }

    public String getValueString(double position, WindowFunction ignored) {
        String valueString = "Copy number: " + this.getScore();
        if (this.snpCount > 0) {
            valueString = valueString + " (" + this.snpCount + " markers)";
        }
        return valueString;
    }

    public void incremenetSnpCount(int inc) {
        this.snpCount += inc;
    }

    public int getSnpCount() {
        return this.snpCount;
    }

    public int getExtendedStart() {
        return this.extendedStart;
    }

    public int getExtendedEnd() {
        return this.extendedEnd;
    }

    public void setExtendedStart(int extendedStart) {
        this.extendedStart = extendedStart;
    }

    public void setExtendedEnd(int extendedEnd) {
        this.extendedEnd = extendedEnd;
    }
}

