/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.seg;

import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.data.seg.SegFileParser;
import org.broad.igv.data.seg.SegmentedAsciiDataSet;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.exceptions.ParserException;
import org.broad.igv.feature.Genome;
import org.broad.igv.session.ViewContext;
import org.broad.igv.synteny.SyntenyMapping;
import org.broad.igv.synteny.SyntenyUtils;
import org.broad.igv.track.TrackType;
import org.broad.igv.util.AsciiLineReader;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;

public class GBenchFileParser
implements SegFileParser {
    private static Logger log = Logger.getLogger(GBenchFileParser.class);
    String testMappings = "test/data/hg18_to_mm8.regions";
    int chrColumn = 1;
    int startColumn = 3;
    int endColumn = 4;
    int snpCountColumn = 5;
    int ampColumn = 6;
    int delColumn = 7;
    ResourceLocator locator;
    Map<String, List<SyntenyMapping>> mappings;

    public GBenchFileParser(ResourceLocator locator) {
        this.locator = locator;
    }

    public void loadSegmentTracks(SegmentedAsciiDataSet dataset) {
        this.loadSegments(dataset);
    }

    public void loadSegments(SegmentedAsciiDataSet dataset) {
        AsciiLineReader reader = null;
        String nextLine = null;
        try {
            reader = ParsingUtils.openAsciiReader(this.locator);
            nextLine = reader.readLine();
            while (nextLine.startsWith("#") || nextLine.trim().length() == 0) {
                if (nextLine.length() > 0) {
                    this.parseComment(nextLine, dataset);
                }
                nextLine = reader.readLine();
            }
            String[] headings = null;
            while ((nextLine = reader.readLine()) != null) {
                if (!nextLine.startsWith("AberrationNo")) continue;
                headings = nextLine.split("\t");
                break;
            }
            if (headings == null) {
                throw new DataLoadException("Error: Cannot find data section.", this.locator.toString());
            }
            Genome genome = ViewContext.getInstance().getGenome();
            String trackId = "";
            while ((nextLine = reader.readLine()) != null && nextLine.trim().length() > 0) {
                int end;
                int start;
                String[] tokens = nextLine.split("\t");
                int nTokens = tokens.length;
                if (nTokens == 1) {
                    trackId = tokens[0];
                    continue;
                }
                if (nTokens <= 4) continue;
                String chr = genome == null ? tokens[this.chrColumn].trim() : genome.getChromosomeAlias(tokens[this.chrColumn].trim());
                try {
                    start = Integer.parseInt(tokens[this.startColumn].trim());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParserException("Column " + (this.startColumn + 1) + " must contain a numeric value.", reader.getCurrentLineNumber(), nextLine);
                }
                try {
                    end = Integer.parseInt(tokens[this.endColumn].trim());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParserException("Column " + (this.endColumn + 1) + " must contain a numeric value.", reader.getCurrentLineNumber(), nextLine);
                }
                int snpCount = 0;
                if (this.snpCountColumn > 0) {
                    try {
                        snpCount = Integer.parseInt(tokens[this.snpCountColumn]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                float value = Float.NaN;
                try {
                    value = Float.parseFloat(tokens[this.ampColumn]);
                    if (value == 0.0f) {
                        value = Float.parseFloat(tokens[this.delColumn]);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (this.mappings != null) {
                    SyntenyMapping m1;
                    List<SyntenyMapping> overlappingMappings;
                    List<SyntenyMapping> tmp = this.mappings.get(chr);
                    if (tmp == null) {
                        System.out.println("No mappings for chr: " + chr);
                        continue;
                    }
                    if (chr.equals("chr1")) {
                        System.out.println();
                    }
                    if ((overlappingMappings = SyntenyUtils.getMappingsOverlapping(tmp, start, end)) == null) {
                        System.out.println("No mapping for: " + chr + ":" + start + "-" + end);
                        continue;
                    }
                    if (overlappingMappings.size() == 1) {
                        m1 = overlappingMappings.get(0);
                        int p1 = (int)m1.mapPosition(start);
                        int p2 = (int)m1.mapPosition(end);
                        start = Math.min(p1, p2);
                        end = Math.max(p1, p2);
                        dataset.addSegment(trackId, m1.getToChr(), start, end, value, snpCount);
                        continue;
                    }
                    m1 = overlappingMappings.get(0);
                    String chr1 = m1.getToChr();
                    int s1 = (int)m1.mapPosition(start);
                    int e1 = m1.getToEnd();
                    if (!m1.getDirection()) {
                        s1 = m1.getToStart();
                        e1 = (int)m1.mapPosition(start);
                    }
                    dataset.addSegment(trackId, chr1, s1, e1, value, snpCount);
                    SyntenyMapping m2 = overlappingMappings.get(overlappingMappings.size() - 1);
                    String chr2 = m2.getToChr();
                    int s2 = (int)m1.mapPosition(end);
                    int e2 = m1.getToEnd();
                    if (!m1.getDirection()) {
                        s2 = m1.getToStart();
                        e2 = (int)m1.mapPosition(end);
                    }
                    dataset.addSegment(trackId, chr2, s2, e2, value, snpCount);
                    for (int i2 = 1; i2 < overlappingMappings.size(); ++i2) {
                        SyntenyMapping m3 = overlappingMappings.get(i2);
                        dataset.addSegment(trackId, m3.getToChr(), m3.getToStart(), m3.getToEnd(), value, snpCount);
                    }
                    continue;
                }
                dataset.addSegment(trackId, chr, start, end, value, snpCount);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            if (nextLine != null && reader.getCurrentLineNumber() != 0L) {
                throw new ParserException(e2.getMessage(), (Throwable)e2, reader.getCurrentLineNumber(), nextLine);
            }
            throw new RuntimeException(e2);
        }
        finally {
            if (reader == null) {
                reader.close();
            }
        }
    }

    private void parseComment(String comment, SegmentedAsciiDataSet dataset) {
        String tmp = comment.substring(1, comment.length());
        String[] tokens = tmp.split("=");
        if (tokens.length != 2) {
            return;
        }
        String key = tokens[0].trim().toLowerCase();
        if (key.equals("type")) {
            try {
                dataset.setTrackType(TrackType.valueOf(tokens[1].trim().toUpperCase()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

