/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broad.igv.data.ExpressionProbe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProbeSet {
    private Map<String, List<ExpressionProbe>> probeLists = new HashMap<String, List<ExpressionProbe>>();
    private Map<String, ExpressionProbe> probes = new HashMap<String, ExpressionProbe>();

    public Set<String> getChromosomes() {
        return this.probeLists.keySet();
    }

    public List<ExpressionProbe> getProbes(String chr) {
        return this.probeLists.get(chr);
    }

    public ExpressionProbe getProbe(String probeId) {
        return this.probes.get(probeId);
    }

    public void add(ExpressionProbe probe) {
        this.probes.put(probe.getName(), probe);
        List<ExpressionProbe> pList = this.probeLists.get(probe.getChr());
        if (pList == null) {
            pList = new ArrayList<ExpressionProbe>(1000);
            this.probeLists.put(probe.getChr(), pList);
        }
        pList.add(probe);
    }

    public void sortProbeLists() {
        for (List<ExpressionProbe> list : this.probeLists.values()) {
            Collections.sort(list);
        }
    }
}

