/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.broad.igv.feature.LocusScore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocusScoreUtils {
    public static List<List<LocusScore>> segreateFeatures(List<LocusScore> features, double scale) {
        ArrayList<List<LocusScore>> segmentedLists = new ArrayList<List<LocusScore>>();
        LinkedList<LocusScore> workingList = new LinkedList<LocusScore>(features);
        LocusScoreUtils.sortFeatureList(workingList);
        while (workingList.size() > 0) {
            LinkedList<LocusScore> nonOverlappingFeatures = new LinkedList<LocusScore>();
            LinkedList<LocusScore> overlappingFeatures = new LinkedList<LocusScore>();
            LocusScore f1 = (LocusScore)workingList.remove(0);
            nonOverlappingFeatures.add(f1);
            while (workingList.size() > 0) {
                int scaledEnd;
                LocusScore f2 = (LocusScore)workingList.remove(0);
                int scaledStart = (int)((double)f2.getStart() / scale);
                if (scaledStart > (scaledEnd = (int)((double)f1.getEnd() / scale))) {
                    nonOverlappingFeatures.add(f2);
                    f1 = f2;
                    continue;
                }
                overlappingFeatures.add(f2);
            }
            segmentedLists.add(nonOverlappingFeatures);
            workingList = overlappingFeatures;
        }
        return segmentedLists;
    }

    public static void sortFeatureList(List<? extends LocusScore> features) {
        Collections.sort(features, new Comparator(){

            public int compare(Object o1, Object o2) {
                LocusScore f1 = (LocusScore)o1;
                LocusScore f2 = (LocusScore)o2;
                return f1.getStart() - f2.getStart();
            }
        });
    }

    public static LocusScore getFeatureAt(double position, double minWidth, List<? extends LocusScore> features) {
        int startIdx = 0;
        int endIdx = features.size();
        while (startIdx != endIdx) {
            int idx = (startIdx + endIdx) / 2;
            LocusScore feature = features.get(idx);
            double effectiveStart = feature.getStart() + 1;
            if (position >= effectiveStart) {
                double effectiveWidth = Math.max(minWidth, (double)(feature.getEnd() - feature.getStart()));
                if (position <= effectiveStart + effectiveWidth) {
                    return features.get(idx);
                }
                if (idx == startIdx) {
                    return null;
                }
                startIdx = idx;
                continue;
            }
            endIdx = idx;
        }
        return null;
    }

    public static LocusScore getFeatureAfter(double position, List<? extends LocusScore> features) {
        int idx;
        if (features.size() == 0 || (double)features.get(features.size() - 1).getStart() <= position) {
            return null;
        }
        int startIdx = 0;
        int endIdx = features.size();
        while (startIdx != endIdx) {
            idx = (startIdx + endIdx) / 2;
            double distance = (double)features.get(idx).getStart() - position;
            if (distance <= 0.0) {
                startIdx = idx;
            } else {
                endIdx = idx;
            }
            if (endIdx - startIdx >= 10) continue;
            break;
        }
        for (idx = startIdx; idx < features.size(); ++idx) {
            if (!((double)features.get(idx).getStart() > position)) continue;
            return features.get(idx);
        }
        return null;
    }

    public static LocusScore getFeatureBefore(double position, List<? extends LocusScore> features) {
        int idx;
        if (features.size() == 0 || (double)features.get(features.size() - 1).getStart() <= position) {
            return null;
        }
        int startIdx = 0;
        int endIdx = features.size() - 1;
        while (startIdx != endIdx) {
            idx = (startIdx + endIdx) / 2;
            double distance = (double)features.get(idx).getStart() - position;
            if (distance <= 0.0) {
                startIdx = idx;
            } else {
                endIdx = idx;
            }
            if (endIdx - startIdx >= 10) continue;
            break;
        }
        if ((double)features.get(endIdx).getStart() >= position) {
            for (idx = endIdx; idx >= 0; --idx) {
                if (!((double)features.get(idx).getStart() < position)) continue;
                return features.get(idx);
            }
        } else {
            for (idx = endIdx + 1; idx < features.size(); ++idx) {
                if (!((double)features.get(idx).getStart() >= position)) continue;
                return features.get(idx - 1);
            }
        }
        return null;
    }
}

