/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import java.util.List;
import org.broad.igv.data.ProcessingUtils;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.track.WindowFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeScore
implements LocusScore {
    List<LocusScore> scores;
    float score;
    private int start;
    private int end;

    public CompositeScore(List<LocusScore> scores, WindowFunction windowFunction) {
        this.scores = scores;
        this.start = Integer.MAX_VALUE;
        this.end = -2147483647;
        for (LocusScore score : scores) {
            this.start = Math.min(this.start, score.getStart());
            this.end = Math.max(this.end, score.getEnd());
        }
        float[] data = new float[scores.size()];
        for (int i2 = 0; i2 < scores.size(); ++i2) {
            data[i2] = scores.get(i2).getScore();
        }
        this.score = ProcessingUtils.computeStat(data, windowFunction);
    }

    public CompositeScore(CompositeScore sc) {
        this.scores = sc.scores;
        this.start = sc.start;
        this.end = sc.end;
        this.score = sc.score;
    }

    @Override
    public CompositeScore copy() {
        return new CompositeScore(this);
    }

    @Override
    public float getScore() {
        return this.score;
    }

    @Override
    public void setConfidence(float confidence) {
    }

    @Override
    public float getConfidence() {
        return 1.0f;
    }

    @Override
    public String getValueString(double position, WindowFunction windowFunction) {
        if (this.scores == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("Composite value = " + this.score + " (" + (Object)((Object)windowFunction) + ")<br>");
        buf.append("-------------------------------<br>");
        buf.append("Components: <br>");
        for (LocusScore s : this.scores) {
            buf.append(s.getValueString(position, windowFunction));
            buf.append("<br>");
        }
        return buf.toString();
    }

    public String getChr() {
        return null;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public void setStart(int start) {
        this.start = start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public void setEnd(int end) {
        this.end = end;
    }

    public int getExtendedStart() {
        return this.getStart();
    }

    public int getExtendedEnd() {
        return this.getEnd();
    }
}

