/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class Globals {
    private static Logger logger = Logger.getLogger(Globals.class);
    public static Color VERY_LIGHT_GREY = new Color(230, 230, 230);
    public static final String CHR_ALL = "All";
    public static boolean headless = false;
    public static boolean suppress = false;
    public static boolean batch = false;
    public static final String SESSION_FILE_EXTENSION = ".xml";
    public static final String GENOME_FILE_EXTENSION = ".genome";
    public static final String SERVER_GENOME_LIST_HEADER = "<Server-Side Genome List>";
    public static final String ZIP_EXTENSION = ".zip";
    public static final String FASTA_GZIP_FILE_EXTENSION = ".gz";
    public static final String GENOME_ARCHIVE_PROPERTY_FILE_NAME = "property.txt";
    public static final String GENOME_ARCHIVE_ID_KEY = "id";
    public static final String GENOME_ARCHIVE_NAME_KEY = "name";
    public static final String GENOME_ARCHIVE_VERSION_KEY = "version";
    public static final String GENOME_ORDERED_KEY = "ordered";
    public static final String GENOME_GENETRACK_NAME = "geneTrackName";
    public static final String GENOME_ARCHIVE_CYTOBAND_FILE_KEY = "cytobandFile";
    public static final String GENOME_ARCHIVE_GENE_FILE_KEY = "geneFile";
    public static final String GENOME_ARCHIVE_SEQUENCE_FILE_LOCATION_KEY = "sequenceLocation";
    public static final String GENOME_SEQUENCE_FOLDER = "sequence";
    public static final String GENOME_CACHE_FOLDER_NAME = "genomes";
    public static final Pattern commaPattern = Pattern.compile(",");
    public static final Pattern tabPattern = Pattern.compile("\t");
    public static final Pattern colonPattern = Pattern.compile(":");
    public static final Pattern dashPattern = Pattern.compile("-");
    public static final Pattern equalPattern = Pattern.compile("=");
    public static List emptyList = new ArrayList();
    public static String VERSION;
    public static String BUILD;
    public static String TIMESTAMP;
    public static final String NO_FEATURES_FOUND_WARNING = "No features were found in this file with chromosomes mapped to the current genome";

    public static void setHeadless(boolean bool) {
        headless = bool;
    }

    public static boolean isHeadless() {
        return headless;
    }

    public static void setSuppress(boolean bool) {
        suppress = bool;
    }

    public static boolean isSuppress() {
        return suppress;
    }

    public static String applicationString() {
        return "IGV Version " + VERSION + " (" + BUILD + ")" + TIMESTAMP;
    }

    public static String versionString() {
        return "<html>Version " + VERSION + " (" + BUILD + ")<br>" + TIMESTAMP;
    }

    static {
        Properties properties = new Properties();
        try {
            properties.load(Globals.class.getResourceAsStream("/resources/about.properties"));
        }
        catch (IOException e2) {
            logger.error("*** Error retrieving version and build information! ***", e2);
        }
        VERSION = properties.getProperty(GENOME_ARCHIVE_VERSION_KEY, "???");
        BUILD = properties.getProperty("build", "???");
        TIMESTAMP = properties.getProperty("timestamp", "???");
    }
}

