/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.picard.util;

import net.sf.samtools.util.StringUtil;

public class SequenceUtil {
    public static final byte a = 97;
    public static final byte c = 99;
    public static final byte g = 103;
    public static final byte t = 116;
    public static final byte A = 65;
    public static final byte C = 67;
    public static final byte G = 71;
    public static final byte T = 84;

    public static String reverseComplement(String sequenceData) {
        byte[] bases = StringUtil.stringToBytes(sequenceData);
        SequenceUtil.reverseComplement(bases);
        return StringUtil.bytesToString(bases);
    }

    public static final byte complement(byte b2) {
        switch (b2) {
            case 97: {
                return 116;
            }
            case 99: {
                return 103;
            }
            case 103: {
                return 99;
            }
            case 116: {
                return 97;
            }
            case 65: {
                return 84;
            }
            case 67: {
                return 71;
            }
            case 71: {
                return 67;
            }
            case 84: {
                return 65;
            }
        }
        return b2;
    }

    public static void reverseComplement(byte[] bases) {
        int lastIndex = bases.length - 1;
        int i2 = 0;
        for (int j2 = lastIndex; i2 < j2; ++i2, --j2) {
            byte tmp = SequenceUtil.complement(bases[i2]);
            bases[i2] = SequenceUtil.complement(bases[j2]);
            bases[j2] = tmp;
        }
        if (bases.length % 2 == 1) {
            bases[i2] = SequenceUtil.complement(bases[i2]);
        }
    }
}

