/*
 * Decompiled with CFR 0.152.
 */
package demos;

import jargs.gnu.CmdLineParser;
import java.util.Enumeration;
import java.util.Vector;

public class JArgsTest {
    private static void printUsage() {
        System.err.println("Usage: OptionTest [-d,--debug] [{-v,--verbose}] [{--alt}] [{--name} a_name]\n                  [{-s,--size} a_number] [{-f,--fraction} a_float] [a_nother]");
    }

    public static void main(String[] args) {
        Boolean verboseValue;
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option debug = parser.addBooleanOption('d', "debug");
        CmdLineParser.Option verbose = parser.addBooleanOption('v', "verbose");
        CmdLineParser.Option size = parser.addIntegerOption('s', "size");
        CmdLineParser.Option fraction = parser.addDoubleOption('f', "fraction");
        CmdLineParser.Option alt = parser.addBooleanOption("alt");
        CmdLineParser.Option name = parser.addStringOption('n', "name");
        try {
            parser.parse(args);
        }
        catch (CmdLineParser.OptionException e2) {
            System.err.println(e2.getMessage());
            JArgsTest.printUsage();
            System.exit(2);
        }
        Boolean debugValue = (Boolean)parser.getOptionValue(debug);
        String nameValue = (String)parser.getOptionValue(name);
        Boolean altValue = (Boolean)parser.getOptionValue(alt, Boolean.FALSE);
        Integer sizeValue = (Integer)parser.getOptionValue(size, new Integer(42));
        Vector fractionValues = parser.getOptionValues(fraction);
        int verbosity = 0;
        while ((verboseValue = (Boolean)parser.getOptionValue(verbose)) != null) {
            ++verbosity;
        }
        String[] otherArgs = parser.getRemainingArgs();
        System.out.println("debug: " + debugValue);
        System.out.println("alt: " + altValue);
        System.out.println("size: " + sizeValue);
        System.out.println("name: " + nameValue);
        System.out.println("verbosity: " + verbosity);
        Enumeration e3 = fractionValues.elements();
        while (e3.hasMoreElements()) {
            System.out.println("fraction: " + (Double)e3.nextElement());
        }
        System.out.println("remaining args: ");
        for (int i2 = 0; i2 < otherArgs.length; ++i2) {
            System.out.println(otherArgs[i2]);
        }
        System.exit(0);
    }
}

