/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.apache.log4j.Logger;
import org.broad.tribble.util.AsciiLineReader;
import org.broad.tribble.util.HttpUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParsingUtils {
    private static Logger log = Logger.getLogger(ParsingUtils.class);
    static Set<String> legacyGenomes = new HashSet<String>();
    private static Map<String, String> humanChrLookupTable;
    private static Map<String, String> chrLookupTable;

    public static BufferedReader openBufferedReader(String path) throws IOException {
        InputStream stream = ParsingUtils.openInputStream(path);
        return new BufferedReader(new InputStreamReader(stream));
    }

    public static AsciiLineReader openAsciiReader(String path) throws IOException {
        InputStream stream = ParsingUtils.openInputStream(path);
        return new AsciiLineReader(stream);
    }

    public static InputStream openInputStream(String path) throws IOException {
        InputStream inputStream = null;
        if (path.startsWith("ftp:")) {
            throw new RuntimeException("FTP streams not supported.");
        }
        if (path.startsWith("http:") || path.startsWith("https:") || path.startsWith("file:")) {
            URL url = new URL(path);
            URLConnection connection = url.openConnection();
            inputStream = connection.getInputStream();
        } else {
            File file = new File(path);
            inputStream = new FileInputStream(file);
        }
        if (path.endsWith("gz")) {
            return new GZIPInputStream(inputStream);
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int estimateLineCount(String filename) {
        AsciiLineReader reader = null;
        try {
            int nLines;
            String nextLine;
            long fileLength = 0L;
            if (filename.startsWith("http:") || filename.startsWith("https:")) {
                URL url = new URL(filename);
                fileLength = Long.parseLong(HttpUtils.getHeaderField(url, "Content-length"));
            } else {
                fileLength = new File(filename).length();
            }
            reader = ParsingUtils.openAsciiReader(filename);
            int lines = 0;
            while ((nextLine = reader.readLine()) != null & lines < 100) {
                ++lines;
            }
            double bytesPerLine = (double)reader.getPosition() / (double)lines;
            int n2 = nLines = (int)((double)fileLength / bytesPerLine);
            Object var11_9 = null;
            reader.close();
            return n2;
        }
        catch (Exception e2) {
            try {
                log.error("Error estimating line count", e2);
                int n3 = 1000;
                Object var11_10 = null;
                reader.close();
                return n3;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                reader.close();
                throw throwable;
            }
        }
    }

    public static String join(String separator, String[] strings) {
        return ParsingUtils.join(separator, strings, 0, strings.length);
    }

    public static String join(String separator, String[] strings, int start, int end) {
        if (end - start == 0) {
            return "";
        }
        StringBuilder ret = new StringBuilder(strings[start]);
        for (int i2 = start + 1; i2 < end; ++i2) {
            ret.append(separator);
            ret.append(strings[i2]);
        }
        return ret.toString();
    }

    public static int split(String aString, String[] tokens, char delim) {
        int maxTokens = tokens.length;
        int nTokens = 0;
        int start = 0;
        int end = aString.indexOf(delim);
        if (end < 0) {
            tokens[nTokens++] = aString;
            return nTokens;
        }
        while (end > 0 && nTokens < maxTokens) {
            tokens[nTokens++] = aString.substring(start, end);
            start = end + 1;
            end = aString.indexOf(delim, start);
        }
        if (nTokens < maxTokens) {
            String trailingString = aString.substring(start);
            tokens[nTokens++] = trailingString;
        }
        return nTokens;
    }

    public static String trim(String str, char ch) {
        int end;
        int start;
        char[] array = str.toCharArray();
        for (start = 0; start < array.length && array[start] == ch; ++start) {
        }
        for (end = array.length - 1; end > start && array[end] == ch; --end) {
        }
        return str.substring(start, end + 1);
    }

    public static int splitWhitespace(String aString, String[] tokens) {
        int end;
        int maxTokens = tokens.length;
        int nTokens = 0;
        int start = 0;
        int tabEnd = aString.indexOf(9);
        int spaceEnd = aString.indexOf(32);
        int n2 = tabEnd < 0 ? spaceEnd : (end = spaceEnd < 0 ? tabEnd : Math.min(spaceEnd, tabEnd));
        while (end > 0 && nTokens < maxTokens) {
            tokens[nTokens++] = aString.substring(start, end);
            for (start = end + 1; start < aString.length() && aString.charAt(start) == ' '; ++start) {
            }
            tabEnd = aString.indexOf(9, start);
            spaceEnd = aString.indexOf(32, start);
            end = tabEnd < 0 ? spaceEnd : (spaceEnd < 0 ? tabEnd : Math.min(spaceEnd, tabEnd));
        }
        if (nTokens < maxTokens) {
            String trailingString = aString.substring(start);
            tokens[nTokens++] = trailingString;
        }
        return nTokens;
    }

    public static List<String> loadRegions(File file) {
        try {
            String nextLine;
            FileInputStream fileInput = new FileInputStream(file);
            BufferedReader reader = new BufferedReader(new InputStreamReader(fileInput));
            ArrayList<String> features = new ArrayList<String>();
            while ((nextLine = reader.readLine()) != null && nextLine.trim().length() > 0) {
                try {
                    if (!nextLine.startsWith("chr")) continue;
                    String[] tokens = nextLine.split("\t");
                    String region = tokens[0] + ":" + tokens[1] + "-" + tokens[2];
                    features.add(region);
                }
                catch (NumberFormatException e2) {
                    log.error("Error parsing numer in line: " + nextLine);
                }
            }
            reader.close();
            return features;
        }
        catch (IOException e3) {
            e3.printStackTrace();
            return null;
        }
    }

    public static String convertChrString(String genomeId, String str) {
        if (str == null) {
            return null;
        }
        String chr = str;
        if (genomeId != null && genomeId.startsWith("hg") || genomeId.startsWith("mm")) {
            if (genomeId.startsWith("hg")) {
                str = str.replace("23", "X");
                str = str.replace("24", "Y");
            } else if (genomeId.startsWith("mm")) {
                str = str.replace("20", "X");
                str = str.replace("21", "Y");
            }
            chr = humanChrLookupTable.get(chr);
            if (chr == null) {
                chr = str;
                humanChrLookupTable.put(str, chr);
            }
        } else if ((chr = chrLookupTable.get(chr)) == null) {
            chr = str;
            chrLookupTable.put(str, chr);
        }
        return chr;
    }

    static {
        legacyGenomes.add("S._cerevisiae");
        legacyGenomes.add("Yeast_S._pombe");
        legacyGenomes.add("Chicken_galGal3");
        humanChrLookupTable = new HashMap<String, String>(100);
        chrLookupTable = new HashMap<String, String>(100);
        for (int i2 = 0; i2 < 23; ++i2) {
            humanChrLookupTable.put(String.valueOf(i2), "chr" + i2);
        }
        humanChrLookupTable.put("X", "chrX");
        humanChrLookupTable.put("Y", "chrY");
        humanChrLookupTable.put("M", "chrM");
        humanChrLookupTable.put("x", "chrX");
        humanChrLookupTable.put("y", "chrY");
        humanChrLookupTable.put("m", "chrM");
    }
}

