/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.index.interval;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.exception.UnsortedFileException;
import org.broad.tribble.index.Block;
import org.broad.tribble.index.Index;
import org.broad.tribble.index.IndexCreator;
import org.broad.tribble.index.interval.Interval;
import org.broad.tribble.index.interval.IntervalTreeIndex;
import org.broad.tribble.util.AsciiLineReader;
import org.broad.tribble.util.LittleEndianOutputStream;

public class IntervalIndexCreator
extends IndexCreator {
    private static Logger log = Logger.getLogger(IntervalIndexCreator.class);
    static int DEFAULT_FEATURE_COUNT = 1000;
    private int featuresPerInterval = DEFAULT_FEATURE_COUNT;
    private boolean verbose = false;

    public IntervalIndexCreator(File featureFile, FeatureCodec codec) {
        super(featureFile, codec);
    }

    public void setFeaturesPerInterval(int featuresPerInterval) {
        this.featuresPerInterval = featuresPerInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Index createIndex() throws IOException {
        featureIndex = new IntervalTreeIndex(this.featureFile.getAbsolutePath());
        is = new FileInputStream(this.featureFile);
        reader = new AsciiLineReader(is);
        this.codec.readHeader(reader);
        fileLength = this.featureFile.length();
        progressIncrement = fileLength / 100L;
        currentFilePosition = 0L;
        lastChr = null;
        lastStart = 0;
        intervalStart = 0;
        intervalEnd = 0;
        progressCounter = 1;
        lineNumber = 0;
        nextLine = "";
        featureCount = 0;
        f = null;
        do {
            ++lineNumber;
            filePosition = reader.getPosition();
        } while ((nextLine = reader.readLine()) != null && (f = this.codec.decodeLoc(nextLine)) == null);
        if (f != null) {
            lastChr = f.getChr();
            intervalStart = f.getStart();
            intervalEnd = f.getEnd();
            ++featureCount;
        }
        while ((nextLine = reader.readLine()) != null) {
            ++lineNumber;
            f = this.codec.decodeLoc(nextLine);
            if (f == null) continue;
            chr = f.getChr();
            if (!chr.equals(lastChr) || ++featureCount >= this.featuresPerInterval) {
                bytesCount = (int)(currentFilePosition - filePosition);
                block = new Block(filePosition, bytesCount);
                interval = new Interval(intervalStart, intervalEnd, block);
                featureIndex.insert(lastChr, interval);
                featureCount = 1;
                intervalStart = f.getStart();
                intervalEnd = f.getEnd();
                filePosition = currentFilePosition;
                lastStart = f.getStart();
                lastChr = chr;
            } else {
                start = f.getStart();
                if (start < lastStart) {
                    throw new UnsortedFileException(" File must be sorted by start position. Sort test failed at: " + nextLine);
                }
                lastStart = start;
                intervalEnd = Math.max(f.getEnd(), intervalEnd);
            }
            if ((currentFilePosition = reader.getPosition()) <= (long)progressCounter * progressIncrement) continue;
            this.updateProgress(progressCounter);
            ++progressCounter;
        }
        bytesCount = (int)(currentFilePosition - filePosition);
        block = new Block(filePosition, bytesCount);
        interval = new Interval(intervalStart, intervalEnd, block);
        featureIndex.insert(lastChr, interval);
        is.close();
        if (this.idxFile != null) {
            stream = null;
            try {
                stream = new LittleEndianOutputStream(new BufferedOutputStream(new FileOutputStream(this.idxFile)));
                featureIndex.write((LittleEndianOutputStream)stream);
                var26_23 = null;
                ** if (stream == null) goto lbl-1000
            }
            catch (Throwable var25_25) {
                var26_24 = null;
                if (stream != null) {
                    stream.close();
                }
                throw var25_25;
            }
lbl-1000:
            // 1 sources

            {
                stream.close();
            }
lbl-1000:
            // 2 sources

            {
            }
        }
        return featureIndex;
    }

    private void updateProgress(int progressCounter) {
        if (this.verbose) {
            System.out.println("Progress: " + progressCounter + "%");
        }
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

