/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

public class TestThreadTiming {
    public static void main(String[] args) {
        int i2;
        int nRepeats = 10000000;
        Compute c1 = new Compute(nRepeats);
        long t0 = System.currentTimeMillis();
        c1.run();
        long dt = System.currentTimeMillis() - t0;
        System.out.println("Single threaded time: " + dt);
        t0 = System.currentTimeMillis();
        int nThreads = 10;
        Thread[] workerThreads = new Thread[10];
        for (i2 = 0; i2 < nThreads; ++i2) {
            Compute c2 = new Compute(nRepeats / nThreads);
            workerThreads[i2] = new Thread(c2);
            workerThreads[i2].start();
        }
        try {
            for (i2 = 0; i2 < nThreads; ++i2) {
                workerThreads[i2].join();
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        dt = System.currentTimeMillis() - t0;
        System.out.println("Multi threaded time:" + dt);
    }

    static class Compute
    implements Runnable {
        int nRepeats;

        Compute(int nRepeats) {
            this.nRepeats = nRepeats;
        }

        public void run() {
            double sum = 0.0;
            for (int i2 = 0; i2 < this.nRepeats; ++i2) {
                sum += 1000000.5;
            }
            System.out.println("Done: " + sum);
        }
    }
}

