/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.ui.WaitCursorManager;
import org.broad.igv.util.NamedRunnable;

public class LongRunningTask
implements Callable {
    private static Logger log = Logger.getLogger(LongRunningTask.class);
    private static ExecutorService threadExecutor = Executors.newFixedThreadPool(3);
    private static ScheduledExecutorService schedule = Executors.newScheduledThreadPool(1);
    NamedRunnable runnable;

    public static Future submit(NamedRunnable runnable) {
        if (Globals.batch) {
            log.debug("Running: " + runnable.getName());
            runnable.run();
            log.debug("Finished : " + runnable.getName());
            return null;
        }
        return threadExecutor.submit(new LongRunningTask(runnable));
    }

    public static Future schedule(NamedRunnable runnable, long time) {
        return schedule.schedule(new LongRunningTask(runnable), time, TimeUnit.MILLISECONDS);
    }

    public LongRunningTask(NamedRunnable runnable) {
        this.runnable = runnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object call() throws Exception {
        String string;
        WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
        try {
            long t0 = System.currentTimeMillis();
            this.runnable.run();
            if (log.isDebugEnabled()) {
                long dt = System.currentTimeMillis() - t0;
                log.debug(this.runnable.getName() + "  time= " + dt);
            }
            string = "";
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            WaitCursorManager.removeWaitCursor(token);
            throw throwable;
        }
        WaitCursorManager.removeWaitCursor(token);
        return string;
    }
}

