/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntHashMap<V> {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    transient Entry[] table;
    transient int size;
    int threshold;
    final float loadFactor;
    volatile transient int modCount;
    static final int NULL_KEY = Integer.MIN_VALUE;

    public IntHashMap(int initialCapacity, float loadFactor) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new Entry[capacity];
        this.init();
    }

    public IntHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntHashMap() {
        this.loadFactor = 0.75f;
        this.threshold = 12;
        this.table = new Entry[16];
        this.init();
    }

    void init() {
    }

    static int hash(int x) {
        int h2 = x;
        h2 += ~(h2 << 9);
        h2 ^= h2 >>> 14;
        h2 += h2 << 4;
        h2 ^= h2 >>> 10;
        return h2;
    }

    static boolean eq(Object x, Object y) {
        return x == y || x.equals(y);
    }

    static int indexFor(int h2, int length) {
        return h2 & length - 1;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public V get(int k2) {
        int hash = IntHashMap.hash(k2);
        int i2 = IntHashMap.indexFor(hash, this.table.length);
        Entry e2 = this.table[i2];
        while (e2 != null) {
            if (e2.hash == hash && IntHashMap.eq(k2, e2.key)) {
                return e2.value;
            }
            e2 = e2.next;
        }
        return null;
    }

    public boolean containsKey(int k2) {
        int hash = IntHashMap.hash(k2);
        int i2 = IntHashMap.indexFor(hash, this.table.length);
        Entry e2 = this.table[i2];
        while (e2 != null) {
            if (e2.hash == hash && IntHashMap.eq(k2, e2.key)) {
                return true;
            }
            e2 = e2.next;
        }
        return false;
    }

    public V put(int k2, V value) {
        int hash = IntHashMap.hash(k2);
        int i2 = IntHashMap.indexFor(hash, this.table.length);
        Entry e2 = this.table[i2];
        while (e2 != null) {
            if (e2.hash == hash && IntHashMap.eq(k2, e2.key)) {
                Object oldValue = e2.value;
                e2.value = value;
                return oldValue;
            }
            e2 = e2.next;
        }
        ++this.modCount;
        this.addEntry(hash, k2, value, i2);
        return null;
    }

    void resize(int newCapacity) {
        Entry[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this.transfer(newTable);
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    void transfer(Entry[] newTable) {
        Entry[] src = this.table;
        int newCapacity = newTable.length;
        for (int j2 = 0; j2 < src.length; ++j2) {
            Entry next;
            Entry e2 = src[j2];
            if (e2 == null) continue;
            src[j2] = null;
            do {
                next = e2.next;
                int i2 = IntHashMap.indexFor(e2.hash, newCapacity);
                e2.next = newTable[i2];
                newTable[i2] = e2;
            } while ((e2 = next) != null);
        }
    }

    public void clear() {
        ++this.modCount;
        Entry[] tab = this.table;
        for (int i2 = 0; i2 < tab.length; ++i2) {
            tab[i2] = null;
        }
        this.size = 0;
    }

    public boolean containsValue(Object value) {
        if (value == null) {
            return this.containsNullValue();
        }
        Entry[] tab = this.table;
        for (int i2 = 0; i2 < tab.length; ++i2) {
            Entry e2 = tab[i2];
            while (e2 != null) {
                if (value.equals(e2.value)) {
                    return true;
                }
                e2 = e2.next;
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        Entry[] tab = this.table;
        for (int i2 = 0; i2 < tab.length; ++i2) {
            Entry e2 = tab[i2];
            while (e2 != null) {
                if (e2.value == null) {
                    return true;
                }
                e2 = e2.next;
            }
        }
        return false;
    }

    void addEntry(int hash, int key, V value, int bucketIndex) {
        Entry e2 = this.table[bucketIndex];
        this.table[bucketIndex] = new Entry<V>(hash, key, value, e2);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    int capacity() {
        return this.table.length;
    }

    float loadFactor() {
        return this.loadFactor;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Entry<V> {
        final int key;
        V value;
        final int hash;
        Entry<V> next;

        Entry(int h2, int k2, V v, Entry<V> n2) {
            this.value = v;
            this.next = n2;
            this.key = k2;
            this.hash = h2;
        }

        public int getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }
}

