/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.awt.Color;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ColorUtilities {
    private static Logger log = Logger.getLogger(ColorUtilities.class);
    public static HashMap colorMap = new HashMap(1000);
    private static float[] whiteComponents = Color.white.getRGBColorComponents(null);
    private static float[] hsbvals = new float[3];

    public static Color randomColor(int idx, int alpha) {
        int col1 = 0;
        int col2 = 0;
        int col3 = 0;
        int BASE_COL = 40;
        int RAND_COL = 255 - BASE_COL;
        col1 = Math.abs(BASE_COL + ++idx * 33 % RAND_COL);
        col2 = Math.abs(BASE_COL + idx * 55 % RAND_COL);
        col3 = Math.abs(BASE_COL + idx * 77 % RAND_COL);
        return new Color(col1, col2, col3, alpha);
    }

    public static Color randomColor(int idx) {
        int col1 = 0;
        int col2 = 0;
        int col3 = 0;
        int BASE_COL = 40;
        int RAND_COL = 255 - BASE_COL;
        col1 = Math.abs(BASE_COL + ++idx * 33 % RAND_COL);
        col2 = Math.abs(BASE_COL + idx * 55 % RAND_COL);
        col3 = Math.abs(BASE_COL + idx * 77 % RAND_COL);
        return new Color(col1, col2, col3);
    }

    public static Color adjustHSB(Color inputColor, float hue, float saturation, float brightness) {
        Color.RGBtoHSB(inputColor.getRed(), inputColor.getGreen(), inputColor.getBlue(), hsbvals);
        return Color.getHSBColor(hue * hsbvals[0], saturation * hsbvals[1], brightness * hsbvals[2]);
    }

    public static String convertColorToRGBString(Color color) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(color.getRed());
        buffer.append(",");
        buffer.append(color.getGreen());
        buffer.append(",");
        buffer.append(color.getBlue());
        return buffer.toString();
    }

    public static Color convertRGBStringToColor(String commaSeparatedRGB) {
        String[] rgb = commaSeparatedRGB.split(",");
        Color color = new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
        return color;
    }

    public static Color getColorFromString(String string) {
        try {
            if (string.contains(",")) {
                String[] rgb = string.split(",");
                int red = Integer.parseInt(rgb[0]);
                int green = Integer.parseInt(rgb[1]);
                int blue = Integer.parseInt(rgb[2]);
                return new Color(red, green, blue);
            }
            if (string.startsWith("#")) {
                string = string.substring(1);
            }
            if (string.length() == 6) {
                int red = Integer.parseInt(string.substring(0, 2), 16);
                int green = Integer.parseInt(string.substring(2, 4), 16);
                int blue = Integer.parseInt(string.substring(4, 6), 16);
                return new Color(red, green, blue);
            }
            return Color.black;
        }
        catch (NumberFormatException numberFormatException) {
            log.error("Error in color string. ", numberFormatException);
            return null;
        }
    }

    public static Color getCompositeColor(float[] dest, float[] source, float alpha) {
        int a2 = 255;
        int r = (int)((double)((alpha * source[0] + (1.0f - alpha) * dest[0]) * 255.0f) + 0.5);
        int g2 = (int)((double)((alpha * source[1] + (1.0f - alpha) * dest[1]) * 255.0f) + 0.5);
        int b2 = (int)((double)((alpha * source[2] + (1.0f - alpha) * dest[2]) * 255.0f) + 0.5);
        int value = (a2 & 0xFF) << 24 | (r & 0xFF) << 16 | (g2 & 0xFF) << 8 | (b2 & 0xFF) << 0;
        Color c2 = (Color)colorMap.get(value);
        if (c2 == null) {
            c2 = new Color(value);
            colorMap.put(value, c2);
        }
        return c2;
    }

    public static Color getCompositeColor(float[] source, float alpha) {
        return ColorUtilities.getCompositeColor(whiteComponents, source, alpha);
    }
}

