/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.util.FileChooser;

public class UIUtilities {
    private static final StringBuffer scratchBuffer = new StringBuffer();

    public static FileChooser getFileChooser(File selectedDirectory, File selectedFile, FileFilter[] fileFilters) {
        return UIUtilities.getFileChooser(selectedDirectory, selectedFile, fileFilters, null);
    }

    public static FileChooser getFileChooser(File selectedDirectory, File selectedFile, FileFilter[] fileFilters, Integer dialogType) {
        FileChooser fileChooser = new FileChooser(selectedDirectory){
            boolean accepted = false;

            public void approveSelection() {
                this.accepted = true;
                super.approveSelection();
            }

            public void cancelSelection() {
                this.setSelectedFile(null);
                super.cancelSelection();
            }

            protected JDialog createDialog(Component parent) throws HeadlessException {
                JDialog dialog = super.createDialog(parent);
                dialog.setLocation(300, 200);
                dialog.setResizable(false);
                dialog.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e2) {
                        if (!accepted) {
                            this.setSelectedFile(null);
                        }
                    }
                });
                return dialog;
            }
        };
        fileChooser.setSelectedFile(selectedFile);
        if (dialogType != null) {
            fileChooser.setDialogType(dialogType);
        }
        if (fileFilters != null) {
            for (FileFilter fileFilter : fileFilters) {
                fileChooser.addChoosableFileFilter(fileFilter);
            }
        }
        return fileChooser;
    }

    public static Color showColorChooserDialog(String dialogTitle, Color defaultColor) {
        Color color = null;
        JColorChooser chooser = new JColorChooser();
        chooser.setColor(defaultColor);
        do {
            int response;
            if ((response = JOptionPane.showConfirmDialog(IGVMainFrame.getInstance(), chooser, dialogTitle, 2)) != 2 && response != -1) continue;
            return null;
        } while ((color = chooser.getColor()) == null);
        return color;
    }

    public static boolean showConfirmationDialog(Component parent, String message) {
        int status = JOptionPane.showConfirmDialog(parent, message, null, 2, -1, null);
        return status != 2 && status != -1;
    }

    public static String getcommaSeparatedRGBString(Color color) {
        if (color != null) {
            scratchBuffer.delete(0, scratchBuffer.length());
            int red = color.getRed();
            int green = color.getGreen();
            int blue = color.getBlue();
            scratchBuffer.append(red);
            scratchBuffer.append(",");
            scratchBuffer.append(green);
            scratchBuffer.append(",");
            scratchBuffer.append(blue);
        }
        return scratchBuffer.toString();
    }

    public static void centerWindow(Window window) {
        Dimension dimension = window.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenSize.width - dimension.width) / 2;
        int y = (screenSize.height - dimension.height) / 2;
        window.setLocation(x, y);
        window.requestFocus();
    }

    public static void invokeOnEventThread(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }
}

