/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import javax.imageio.ImageIO;
import javax.swing.filechooser.FileFilter;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.log4j.Logger;
import org.broad.igv.ui.util.MessageUtils;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class GenericUtilities {
    private static Logger logger = Logger.getLogger(GenericUtilities.class);
    private static final LinkedHashMap<SnapshotFileType, SnapshotFileFilter> SNAPSHOT_TYPE_TO_FILTER = new LinkedHashMap();

    public static FileFilter[] getAllSnapshotFileFilters() {
        return SNAPSHOT_TYPE_TO_FILTER.values().toArray(new FileFilter[SNAPSHOT_TYPE_TO_FILTER.size()]);
    }

    public static SnapshotFileFilter getSnapshotFileFilterForType(SnapshotFileType type) {
        return SNAPSHOT_TYPE_TO_FILTER.get((Object)type);
    }

    public static BufferedImage getDeviceCompatibleImage(int width, int height) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice screenDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicConfiguration = screenDevice.getDefaultConfiguration();
        BufferedImage image = graphicConfiguration.createCompatibleImage(width, height);
        return image;
    }

    public static String getFileExtension(String filePath) {
        String extension = null;
        int indexOfExtension = filePath.lastIndexOf(".");
        if (indexOfExtension >= 0) {
            extension = filePath.substring(indexOfExtension, filePath.length());
        }
        return extension;
    }

    public static SnapshotFileType getSnapshotFileType(String fileExtension) {
        String extension = fileExtension.toLowerCase();
        SnapshotFileType type = null;
        type = SnapshotFileType.EPS.getExtension().equals(extension) ? SnapshotFileType.EPS : (SnapshotFileType.PDF.getExtension().equals(extension) ? SnapshotFileType.PDF : (SnapshotFileType.SVG.getExtension().equals(extension) ? SnapshotFileType.SVG : (SnapshotFileType.PNG.getExtension().equals(extension) ? SnapshotFileType.PNG : (SnapshotFileType.JPEG.getExtension().equals(extension) ? SnapshotFileType.JPEG : SnapshotFileType.NULL))));
        return type;
    }

    public static boolean isValidSnapshotFileType(SnapshotFileType type) {
        boolean isValid = false;
        if (SnapshotFileType.EPS.equals((Object)type) || SnapshotFileType.PDF.equals((Object)type) || SnapshotFileType.SVG.equals((Object)type) || SnapshotFileType.PNG.equals((Object)type) || SnapshotFileType.JPEG.equals((Object)type)) {
            isValid = true;
        }
        return isValid;
    }

    public static void doComponentSnapshot(Component component, File file, SnapshotFileType type) {
        int width = component.getWidth();
        int height = component.getHeight();
        switch (type) {
            case JPEG: {
                GenericUtilities.exportScreenShotJPEG(component, file, width, height);
                break;
            }
            case PNG: {
                GenericUtilities.exportScreenShotPNG(component, file, width, height);
                break;
            }
            case SVG: {
                logger.debug("Exporting svg screenshot");
                GenericUtilities.exportScreenshotSVG(component, file, width, height);
            }
        }
    }

    private static void exportScreenshotSVG(Component target, File selecteddFile, int width, int height) {
        try {
            logger.info("Getting dom");
            DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
            String svgNS = "http://www.w3.org/2000/svg";
            Document document = domImpl.createDocument(svgNS, "svg", null);
            SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
            target.paintAll(svgGenerator);
            boolean useCSS = true;
            BufferedWriter out = new BufferedWriter(new FileWriter(selecteddFile));
            svgGenerator.stream(out, useCSS);
        }
        catch (Exception e2) {
            logger.error("Error creating SVG file", e2);
            MessageUtils.showMessage("Error encountered creating SVG file: " + e2.toString());
        }
    }

    private static void exportScreenShotJPEG(Component target, File selectedFile, int width, int height) {
        BufferedImage image = GenericUtilities.getDeviceCompatibleImage(width, height);
        Graphics2D g2 = image.createGraphics();
        target.paintAll(g2);
        if (selectedFile != null) {
            if (!selectedFile.getName().toLowerCase().endsWith(".jpeg")) {
                String correctedFilename = selectedFile.getAbsolutePath() + ".jpeg";
                selectedFile = new File(correctedFilename);
            }
            GenericUtilities.writeImage(image, selectedFile, "jpeg");
        }
    }

    private static void exportScreenShotPNG(Component target, File selectedFile, int width, int height) {
        BufferedImage image = GenericUtilities.getDeviceCompatibleImage(width, height);
        Graphics2D g2 = image.createGraphics();
        target.paintAll(g2);
        if (selectedFile != null) {
            if (!selectedFile.getName().toLowerCase().endsWith(".png")) {
                String correctedFilename = selectedFile.getAbsolutePath() + ".png";
                selectedFile = new File(correctedFilename);
            }
            GenericUtilities.writeImage(image, selectedFile, "png");
        }
    }

    private static void writeImage(BufferedImage image, File f2, String type) {
        try {
            ImageIO.write((RenderedImage)image, type, f2);
        }
        catch (IOException e2) {
            logger.error("Error creating: " + f2.getAbsolutePath(), e2);
        }
    }

    static {
        SNAPSHOT_TYPE_TO_FILTER.put(SnapshotFileType.JPEG, new SnapshotFileFilter(SnapshotFileType.JPEG));
        SNAPSHOT_TYPE_TO_FILTER.put(SnapshotFileType.SVG, new SnapshotFileFilter(SnapshotFileType.SVG));
        SNAPSHOT_TYPE_TO_FILTER.put(SnapshotFileType.PNG, new SnapshotFileFilter(SnapshotFileType.PNG));
    }

    public static class GenomeArchiveFileFilter
    extends FileFilter {
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return file.getName().toLowerCase().endsWith(".genome");
        }

        public String getDescription() {
            return "Genome Archive File";
        }

        public String getExtension() {
            return ".genome";
        }
    }

    public static class SnapshotFileFilter
    extends FileFilter {
        private SnapshotFileType type = SnapshotFileType.EPS;

        public SnapshotFileFilter(SnapshotFileType type) {
            this.type = type;
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return file.getName().toLowerCase().endsWith(this.type.getExtension());
        }

        public String getDescription() {
            return this.type.getDescription();
        }

        public String getExtension() {
            return this.type.getExtension();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SnapshotFileType {
        NULL("", ""),
        EPS(".eps", "Encapsulated Postscript Files (*.eps)"),
        PDF(".pdf", "Portable Document FormatFles (*.pdf)"),
        SVG(".svg", "Scalable Vector Graphics Files (*.svg)"),
        PNG(".png", "Portable Network Graphics Files (*.png)"),
        JPEG(".jpeg", "Joint Photographic Experts Group Files (*.jpeg)");

        private String fileExtension;
        private String fileDescription;

        private SnapshotFileType(String extension, String description) {
            this.fileExtension = extension;
            this.fileDescription = description;
        }

        public String getExtension() {
            return this.fileExtension;
        }

        public String getDescription() {
            return this.fileDescription;
        }
    }
}

