/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.ui.AttributeSelectionDialog;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.UIUtilities;

public class GroupTracksMenuAction
extends MenuAction {
    IGVMainFrame mainFrame;

    public GroupTracksMenuAction(String label, int mnemonic, IGVMainFrame mainFrame) {
        super(label, null, mnemonic);
        this.mainFrame = mainFrame;
        this.setToolTipText("Group tracks");
    }

    public void actionPerformed(ActionEvent e2) {
        UIUtilities.invokeOnEventThread(new Runnable(){

            public void run() {
                GroupTracksMenuAction.this.doGroupBy();
            }
        });
    }

    public final void doGroupBy() {
        AttributeSelectionDialog dlg = new AttributeSelectionDialog((Frame)this.mainFrame, true);
        List<String> attributeKeys = AttributeManager.getInstance().getAttributeKeys();
        ArrayList<String> selections = new ArrayList<String>(attributeKeys);
        selections.add(0, "None");
        String[] selArray = selections.toArray(new String[0]);
        dlg.setModel(new DefaultComboBoxModel<String>(selArray));
        dlg.setDefaultCloseOperation(2);
        String currentSelection = IGVMainFrame.getInstance().getTrackManager().getGroupByAttribute();
        if (currentSelection == null) {
            dlg.setSelectedIndex(0);
        } else {
            dlg.setSelectedItem(currentSelection);
        }
        dlg.setVisible(true);
        if (!dlg.isCanceled()) {
            int selIndex = dlg.getSelectedIndex();
            String selectedAttribute = selIndex == 0 ? null : selArray[selIndex];
            System.out.println("Enter group tracks");
            IGVMainFrame.getInstance().getTrackManager().setGroupByAttribute(selectedAttribute);
            System.out.println("Exit group tracks");
            this.mainFrame.updateTrackState();
        }
    }
}

