/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackGroup;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.panel.DataPanel;
import org.broad.igv.ui.panel.TrackPanelScrollPane;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.NamedRunnable;

public class FitDataToWindowMenuAction
extends MenuAction {
    static Logger log = Logger.getLogger(FitDataToWindowMenuAction.class);
    IGVMainFrame mainFrame;

    public FitDataToWindowMenuAction(String label, int mnemonic, IGVMainFrame mainFrame) {
        super(label, null, mnemonic);
        this.mainFrame = mainFrame;
        this.setToolTipText("Resizes all track heights in order to make all tracks visible in their display with no vertical scrolling");
    }

    public void actionPerformed(ActionEvent e2) {
        NamedRunnable runnable = new NamedRunnable(){

            public void run() {
                for (TrackPanelScrollPane sp : IGVMainFrame.getInstance().getTrackManager().getTrackPanelScrollPanes()) {
                    FitDataToWindowMenuAction.this.fitTracksToPanel(sp.getDataPanel());
                    sp.getDataPanel().doResize();
                }
                FitDataToWindowMenuAction.this.mainFrame.doRefresh();
            }

            public String getName() {
                return "Fit data to window";
            }
        };
        LongRunningTask.submit(runnable);
    }

    private boolean fitTracksToPanel(DataPanel dataPanel) {
        int groupGapHeight;
        int adjustedVisibleHeight;
        boolean success = true;
        int visibleHeight = dataPanel.getVisibleHeight();
        int visibleTrackCount = 0;
        boolean geneTrackHeight = false;
        Collection<TrackGroup> groups = dataPanel.getTrackGroups();
        for (TrackGroup group : groups) {
            List<Track> tracks = group.getTracks();
            for (Track track : tracks) {
                if (!track.isVisible()) continue;
                ++visibleTrackCount;
            }
        }
        if (visibleTrackCount > 0 && (adjustedVisibleHeight = visibleHeight - (groupGapHeight = (groups.size() + 1) * 10)) > 0) {
            float delta = (float)adjustedVisibleHeight / (float)visibleTrackCount;
            if (delta < 1.0f) {
                delta = 1.0f;
            }
            int iTotal = 0;
            float target = 0.0f;
            for (TrackGroup group : groups) {
                List<Track> tracks = group.getTracks();
                for (Track track : tracks) {
                    int newHeight = Math.round((target += delta) - (float)iTotal);
                    iTotal += newHeight;
                    if (!track.isVisible()) continue;
                    track.setHeight(newHeight);
                }
            }
        }
        return success;
    }
}

