/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideToggleButton;
import com.jidesoft.utils.SwingWorker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Rectangle2D;
import java.io.FileNotFoundException;
import java.net.NoRouteToHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.GenomeManager;
import org.broad.igv.feature.GenomeServerException;
import org.broad.igv.session.ViewContext;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.WaitCursorManager;
import org.broad.igv.ui.ZoomSliderPanel;
import org.broad.igv.ui.action.SearchCommand;
import org.broad.igv.ui.util.IconFactory;
import org.broad.igv.ui.util.ProgressBar;
import org.broad.igv.ui.util.ProgressMonitor;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.LRUCache;
import org.broad.igv.util.NamedRunnable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IGVCommandBar
extends JPanel {
    private static Logger log = Logger.getLogger(IGVCommandBar.class);
    private IGVMainFrame owner;
    private LinkedHashSet<GenomeManager.GenomeListItem> userDefinedGenomeItemList;
    private LinkedHashSet<GenomeManager.GenomeListItem> serverGenomeItemList;
    private LinkedHashSet<GenomeManager.GenomeListItem> cachedGenomeItemList;
    private JComboBox chromosomeComboBox;
    private JComboBox genomeComboBox;
    private JideButton goButton;
    private JideButton homeButton;
    private JPanel locationPanel;
    private JideButton refreshButton;
    private JideToggleButton roiToggleButton;
    private JTextField searchTextField;
    private JPanel toolPanel;
    private JPanel zoomControl;
    private ItemListener genomeComboBoxItemListener = null;
    private final int DEFAULT_CHROMOSOME_DROPDOWN_WIDTH = 120;
    private JideButton backButton;
    private JideButton forwardButton;

    public IGVCommandBar(IGVMainFrame owner) {
        this.owner = owner;
        this.initComponents();
        String currentChr = this.getViewContext().getChrName();
        this.chromosomeComboBox.setSelectedItem(currentChr);
        boolean roiVisible = PreferenceManager.getInstance().getShowRegionTool();
        this.roiToggleButton.setVisible(roiVisible);
        boolean isWholeGenome = currentChr.equals("All");
        this.roiToggleButton.setEnabled(!isWholeGenome);
        this.zoomControl.setEnabled(!isWholeGenome);
    }

    public boolean isGenomeCached(String genome) {
        boolean isCached = false;
        if (this.cachedGenomeItemList != null && !this.cachedGenomeItemList.isEmpty()) {
            for (GenomeManager.GenomeListItem item : this.cachedGenomeItemList) {
                if (!item.getId().equalsIgnoreCase(genome)) continue;
                isCached = true;
            }
        }
        return isCached;
    }

    public void initializeGenomeList(ProgressMonitor monitor) throws FileNotFoundException, NoRouteToHostException {
        if (log.isDebugEnabled()) {
            log.debug("Enter initializeGenomeList");
        }
        if (monitor != null) {
            monitor.fireProgressChange(1);
        }
        this.genomeComboBox.removeAllItems();
        this.genomeComboBox.setRenderer(new ComboBoxRenderer());
        this.genomeComboBox.setToolTipText("Switch the current genome");
        this.rebuildGenomeItemList(null);
        if (monitor != null) {
            monitor.fireProgressChange(50);
        }
        this.genomeComboBox.addItemListener(this.getGenomeComboBoxItemListener());
        LinkedHashSet<GenomeManager.GenomeListItem> mergedServerAndCacheItemList = new LinkedHashSet<GenomeManager.GenomeListItem>();
        if (this.userDefinedGenomeItemList != null) {
            mergedServerAndCacheItemList.addAll(this.userDefinedGenomeItemList);
        }
        if (this.cachedGenomeItemList != null) {
            mergedServerAndCacheItemList.addAll(this.cachedGenomeItemList);
        }
        if (this.serverGenomeItemList != null) {
            mergedServerAndCacheItemList.addAll(this.serverGenomeItemList);
        }
        this.getSearchTextField().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionevent) {
                IGVCommandBar.this.goButtonActionPerformed(actionevent);
            }
        });
        if (log.isDebugEnabled()) {
            log.debug("Exit initializeGenomeList");
        }
    }

    public ItemListener getGenomeComboBoxItemListener() {
        if (this.genomeComboBoxItemListener == null) {
            this.genomeComboBoxItemListener = new ItemListener(){
                int previousSelectedItemId = 0;

                private void reselectPreviousGenome() {
                    if (this.previousSelectedItemId != -1) {
                        final int index = this.previousSelectedItemId;
                        UIUtilities.invokeOnEventThread(new Runnable(){

                            public void run() {
                                IGVCommandBar.this.genomeComboBox.setSelectedIndex(index);
                            }
                        });
                    }
                    this.previousSelectedItemId = -1;
                }

                public void itemStateChanged(final ItemEvent itemEvent) {
                    if (1 != itemEvent.getStateChange()) {
                        return;
                    }
                    SwingWorker worker = new SwingWorker(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        protected Object doInBackground() throws Exception {
                            Object item = itemEvent.getItem();
                            if (item instanceof GenomeManager.GenomeListItem) {
                                GenomeManager.GenomeListItem genomeListItem = (GenomeManager.GenomeListItem)item;
                                String requestedGenomeId = genomeListItem.getId();
                                String currentGenomeId = ViewContext.getInstance().getGenomeId();
                                if (currentGenomeId != null && requestedGenomeId.equalsIgnoreCase(currentGenomeId)) {
                                    return null;
                                }
                                ProgressMonitor monitor = new ProgressMonitor();
                                final ProgressBar bar = ProgressBar.showProgressDialog(IGVMainFrame.getInstance(), "Loading Genome...", monitor, false);
                                if (requestedGenomeId != null) {
                                    try {
                                        monitor.fireProgressChange(50);
                                        GenomeManager.getInstance().loadGenome(genomeListItem, genomeListItem.isUserDefined());
                                        monitor.fireProgressChange(25);
                                        if (!IGVCommandBar.this.isGenomeCached(genomeListItem.getId())) {
                                            IGVCommandBar.this.cachedGenomeItemList.add(genomeListItem);
                                        }
                                        IGVMainFrame.getInstance().doChooseGenome(GenomeManager.getInstance().getGenomeDescriptor(requestedGenomeId));
                                        previousSelectedItemId = IGVCommandBar.this.genomeComboBox.getSelectedIndex();
                                        monitor.fireProgressChange(25);
                                        UIUtilities.invokeOnEventThread(new Runnable(){

                                            public void run() {
                                                if (bar != null) {
                                                    bar.close();
                                                }
                                            }
                                        });
                                    }
                                    catch (GenomeServerException e2) {
                                        UIUtilities.invokeOnEventThread(new Runnable(){

                                            public void run() {
                                                JOptionPane.showMessageDialog(IGVMainFrame.getInstance(), "The Genome server is currently inaccessible.");
                                            }
                                        });
                                        this.reselectPreviousGenome();
                                        Object var8_10 = null;
                                        return var8_10;
                                    }
                                    catch (FileNotFoundException e3) {
                                        UIUtilities.invokeOnEventThread(new Runnable(){

                                            public void run() {
                                                if (bar != null) {
                                                    bar.close();
                                                }
                                            }
                                        });
                                        int choice = JOptionPane.showConfirmDialog(IGVMainFrame.getInstance(), "The genome file [" + e3.getMessage() + "] could not be located. " + "Would you like to remove the selected entry?", "", 2);
                                        if (choice == 0) {
                                            HashSet<String> excludedArchivesUrls = new HashSet<String>();
                                            excludedArchivesUrls.add(genomeListItem.getLocation());
                                            IGVCommandBar.this.rebuildGenomeItemList(excludedArchivesUrls);
                                        }
                                        this.reselectPreviousGenome();
                                        Object var9_13 = null;
                                        return var9_13;
                                    }
                                    catch (Exception e4) {
                                        this.reselectPreviousGenome();
                                        Object var8_12 = null;
                                        return var8_12;
                                    }
                                    finally {
                                        IGVMainFrame.getInstance().repaint();
                                    }
                                }
                            }
                            return null;
                        }
                    };
                    worker.execute();
                }
            };
        }
        return this.genomeComboBoxItemListener;
    }

    public void addToUserDefinedGenomeItemList(GenomeManager.GenomeListItem newItem) {
        if (this.userDefinedGenomeItemList == null) {
            this.userDefinedGenomeItemList = new LinkedHashSet();
            this.userDefinedGenomeItemList.add(newItem);
        } else {
            LinkedHashSet<GenomeManager.GenomeListItem> tempItemList = new LinkedHashSet<GenomeManager.GenomeListItem>();
            tempItemList.add(newItem);
            for (GenomeManager.GenomeListItem item : this.userDefinedGenomeItemList) {
                tempItemList.add(item);
            }
            this.userDefinedGenomeItemList = tempItemList;
        }
        this.setGenomeItemListModel();
    }

    public void rebuildGenomeItemList(Set excludedArchivesUrls) {
        try {
            LinkedHashSet<GenomeManager.GenomeListItem> serverSideItemList = null;
            try {
                serverSideItemList = GenomeManager.getInstance().getServerGenomeArchiveList(excludedArchivesUrls);
            }
            catch (Exception e2) {
                UIUtilities.invokeOnEventThread(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(IGVMainFrame.getInstance(), "The Genome server is currently inaccessible.");
                    }
                });
            }
            LinkedHashSet<GenomeManager.GenomeListItem> cacheGenomeItemList = GenomeManager.getInstance().getCachedGenomeArchiveList();
            LinkedHashSet<GenomeManager.GenomeListItem> clientSideItemList = GenomeManager.getInstance().getUserDefinedGenomeArchiveList();
            this.setGenomeItemList(clientSideItemList, serverSideItemList, cacheGenomeItemList);
            this.setGenomeItemListModel();
        }
        catch (Exception e3) {
            log.error("Failed to get genome archive list information from the server!", e3);
        }
    }

    void updateChromosomeDropdown() {
        String homeChr;
        LinkedList<String> tmp = new LinkedList<String>(this.getViewContext().getChromosomeNames());
        if (tmp.size() > 1 && (homeChr = this.getViewContext().getHomeChr()).equals("All")) {
            tmp.add("All");
        }
        Graphics2D graphics2D = (Graphics2D)this.chromosomeComboBox.getGraphics();
        Font font = this.chromosomeComboBox.getFont();
        FontMetrics fontMetrics = this.chromosomeComboBox.getFontMetrics(font);
        int fontSize = font.getSize();
        int w = 120;
        for (String chromosomeName : tmp) {
            int width;
            Rectangle2D textBounds = fontMetrics.getStringBounds(chromosomeName, graphics2D);
            if (textBounds == null || (width = textBounds.getBounds().width + 50) <= w) continue;
            w = width;
        }
        Object[] chomosomeNames = tmp.toArray();
        final DefaultComboBoxModel<Object> defaultModel = new DefaultComboBoxModel<Object>(chomosomeNames);
        final int dropdownWidth = w;
        UIUtilities.invokeOnEventThread(new Runnable(){

            public void run() {
                IGVCommandBar.this.adjustChromosomeDropdownWidth(dropdownWidth);
                IGVCommandBar.this.chromosomeComboBox.setModel(defaultModel);
                IGVCommandBar.this.chromosomeComboBox.setSelectedItem(IGVCommandBar.this.getViewContext().getChrName());
            }
        });
    }

    protected void chromosomeChanged() {
        this.roiToggleButton.setEnabled(!this.getViewContext().getChrName().equals("All"));
        this.zoomControl.setEnabled(!this.getViewContext().getChrName().equals("All"));
        if (this.chromosomeComboBox.getSelectedItem() != null && !this.chromosomeComboBox.getSelectedItem().equals(this.getViewContext().getChrName())) {
            this.chromosomeComboBox.setSelectedItem(this.getViewContext().getChrName());
        }
    }

    public void updateCurrentCoordinates() {
        this.getSearchTextField().setText("");
        String chr = this.getViewContext().getChrName();
        if (!chr.equals(this.chromosomeComboBox.getSelectedItem())) {
            this.chromosomeChanged();
            this.chromosomeComboBox.setSelectedItem(chr);
            this.owner.chromosomeChangeEvent(false);
        }
        String p2 = "";
        if (!chr.equals("All")) {
            p2 = this.getViewContext().getFormattedLocusString();
        }
        final String position = p2;
        UIUtilities.invokeOnEventThread(new Runnable(){

            public void run() {
                IGVCommandBar.this.getSearchTextField().setText(position);
            }
        });
    }

    public String getSearchText() {
        return this.getSearchTextField().getText();
    }

    private JTextField getSearchTextField() {
        return this.searchTextField;
    }

    private ViewContext getViewContext() {
        return ViewContext.getInstance();
    }

    public void selectFirstGenomeInList() {
        int itemCount = this.genomeComboBox.getItemCount();
        for (int i2 = 0; i2 < itemCount; ++i2) {
            Object object = this.genomeComboBox.getItemAt(i2);
            if (!(object instanceof GenomeManager.GenomeListItem)) continue;
            GenomeManager.GenomeListItem genomeListItem = (GenomeManager.GenomeListItem)object;
            this.genomeComboBox.setSelectedIndex(i2);
            String id = genomeListItem.getId();
            IGVMainFrame.getInstance().setGenomeId(id);
            break;
        }
    }

    public Collection<String> getGenomeDisplayNames() {
        ArrayList<String> displayNames = new ArrayList<String>();
        int itemCount = this.genomeComboBox.getItemCount();
        for (int i2 = 0; i2 < itemCount; ++i2) {
            Object object = this.genomeComboBox.getItemAt(i2);
            if (!(object instanceof GenomeManager.GenomeListItem)) continue;
            GenomeManager.GenomeListItem genomeListItem = (GenomeManager.GenomeListItem)object;
            displayNames.add(genomeListItem.getDisplayableName());
        }
        return displayNames;
    }

    public Collection<String> getGenomeListItemIds() {
        ArrayList<String> ids = new ArrayList<String>();
        int itemCount = this.genomeComboBox.getItemCount();
        for (int i2 = 0; i2 < itemCount; ++i2) {
            Object object = this.genomeComboBox.getItemAt(i2);
            if (!(object instanceof GenomeManager.GenomeListItem)) continue;
            GenomeManager.GenomeListItem genomeListItem = (GenomeManager.GenomeListItem)object;
            ids.add(genomeListItem.getId());
        }
        return ids;
    }

    public void selectGenomeFromListWithNoImport(String genomeId) {
        int itemCount = this.genomeComboBox.getItemCount();
        for (int i2 = 0; i2 < itemCount; ++i2) {
            GenomeManager.GenomeListItem genomeListItem;
            String id;
            Object object = this.genomeComboBox.getItemAt(i2);
            if (!(object instanceof GenomeManager.GenomeListItem) || (id = (genomeListItem = (GenomeManager.GenomeListItem)object).getId()) == null || !id.trim().equalsIgnoreCase(genomeId)) continue;
            this.genomeComboBox.setSelectedIndex(i2);
            IGVMainFrame.getInstance().setGenomeId(id);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectGenomeFromList(final String genomeId) throws FileNotFoundException, NoRouteToHostException {
        String currentGenomeId = ViewContext.getInstance().getGenomeId();
        if (currentGenomeId != null && genomeId != null && genomeId.equalsIgnoreCase(currentGenomeId)) {
            return;
        }
        NamedRunnable runnable = new NamedRunnable(){

            public void run() {
                Object object;
                int i2;
                log.debug("Run selectGenomeFromList");
                boolean ignoreCache = false;
                boolean wasFound = false;
                if (genomeId != null) {
                    try {
                        int itemCount = IGVCommandBar.this.genomeComboBox.getItemCount();
                        for (i2 = 0; i2 < itemCount; ++i2) {
                            GenomeManager.GenomeListItem genomeListItem;
                            String id;
                            object = IGVCommandBar.this.genomeComboBox.getItemAt(i2);
                            if (!(object instanceof GenomeManager.GenomeListItem) || (id = (genomeListItem = (GenomeManager.GenomeListItem)object).getId()) == null || !id.trim().equalsIgnoreCase(genomeId)) continue;
                            if (log.isDebugEnabled()) {
                                log.debug("Call loadGenome");
                            }
                            GenomeManager.getInstance().loadGenome(genomeListItem.getLocation(), genomeListItem.isUserDefined(), null);
                            IGVCommandBar.this.genomeComboBox.setSelectedIndex(i2);
                            wasFound = true;
                            IGVMainFrame.getInstance().setGenomeId(genomeId);
                            break;
                        }
                    }
                    catch (FileNotFoundException ex) {
                        log.error("Genome file not found. ", ex);
                    }
                }
                if (!wasFound) {
                    int count = IGVCommandBar.this.genomeComboBox.getItemCount();
                    for (i2 = 0; i2 < count; ++i2) {
                        object = IGVCommandBar.this.genomeComboBox.getItemAt(i2);
                        if (!(object instanceof GenomeManager.GenomeListItem)) continue;
                        GenomeManager.GenomeListItem item = (GenomeManager.GenomeListItem)object;
                        try {
                            GenomeManager.getInstance().loadGenome(item, item.isUserDefined());
                            IGVMainFrame.getInstance().setGenomeId(item.getId());
                            IGVCommandBar.this.genomeComboBox.setSelectedIndex(i2);
                            break;
                        }
                        catch (FileNotFoundException ex) {
                            log.error("Genome file not found ", ex);
                        }
                    }
                }
                log.debug("Finish selectGenomeFromList");
            }

            public String getName() {
                return "selectGenomeFromList: " + genomeId;
            }
        };
        WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
        try {
            runnable.run();
        }
        finally {
            WaitCursorManager.removeWaitCursor(token);
        }
    }

    public DefaultComboBoxModel getModelForGenomeListComboBox() {
        LinkedHashSet<Object> list = new LinkedHashSet<Object>();
        if (this.userDefinedGenomeItemList != null && !this.userDefinedGenomeItemList.isEmpty()) {
            for (GenomeManager.GenomeListItem item : this.userDefinedGenomeItemList) {
                list.add(item);
            }
            list.add("--SEPARATOR--");
        }
        if (this.serverGenomeItemList != null && !this.serverGenomeItemList.isEmpty()) {
            for (GenomeManager.GenomeListItem item : this.serverGenomeItemList) {
                list.add(item);
            }
            if (this.cachedGenomeItemList == null || this.cachedGenomeItemList.isEmpty()) {
                list.add("--SEPARATOR--");
            }
        }
        if (this.cachedGenomeItemList != null && !this.cachedGenomeItemList.isEmpty()) {
            for (GenomeManager.GenomeListItem item : this.cachedGenomeItemList) {
                list.add(item);
            }
            list.add("--SEPARATOR--");
        }
        if (list.isEmpty()) {
            list.add(GenomeManager.getInstance().getDefaultGenomeListItem());
        }
        return new DefaultComboBoxModel<Object>(list.toArray());
    }

    public void intializeDefaultGenome(ProgressMonitor monitor) throws FileNotFoundException, NoRouteToHostException {
        LinkedHashSet<GenomeManager.GenomeListItem> mergedServerAndCacheItemList = new LinkedHashSet<GenomeManager.GenomeListItem>();
        if (this.userDefinedGenomeItemList != null) {
            mergedServerAndCacheItemList.addAll(this.userDefinedGenomeItemList);
        }
        if (this.cachedGenomeItemList != null) {
            mergedServerAndCacheItemList.addAll(this.cachedGenomeItemList);
        }
        if (this.serverGenomeItemList != null) {
            mergedServerAndCacheItemList.addAll(this.serverGenomeItemList);
        }
        this.grabFocus();
    }

    public void setGenomeItemList(LinkedHashSet<GenomeManager.GenomeListItem> clientItemList, LinkedHashSet<GenomeManager.GenomeListItem> serverItemList, LinkedHashSet<GenomeManager.GenomeListItem> cachedGenomeItemList) {
        if (clientItemList == null) {
            clientItemList = new LinkedHashSet();
        }
        if (serverItemList == null) {
            serverItemList = new LinkedHashSet();
        }
        if (cachedGenomeItemList == null) {
            cachedGenomeItemList = new LinkedHashSet();
        }
        this.userDefinedGenomeItemList = clientItemList;
        this.cachedGenomeItemList = cachedGenomeItemList;
        this.serverGenomeItemList = serverItemList;
    }

    public void setGenomeItemListModel() {
        this.genomeComboBox.setModel(this.getModelForGenomeListComboBox());
    }

    private void initComponents() {
        this.setMinimumSize(new Dimension(200, 32));
        JideBoxLayout layout = new JideBoxLayout(this, 0);
        this.setLayout(layout);
        this.locationPanel = new JPanel();
        this.locationPanel.setBorder(new LineBorder(Color.lightGray, 1, true));
        this.locationPanel.setPreferredSize(new Dimension(150, 20));
        this.locationPanel.setLayout(new JideBoxLayout(this.locationPanel, 0));
        this.locationPanel.setAlignmentY(0.5f);
        this.locationPanel.add(Box.createRigidArea(new Dimension(10, 36)), "fix");
        this.genomeComboBox = new JComboBox(){

            public void setSelectedIndex(int index) {
                Object object = this.getItemAt(index);
                String text = object.toString();
                if (object instanceof GenomeManager.GenomeListItem) {
                    super.setSelectedIndex(index);
                } else if (text.equals("Load Genome...")) {
                    IGVMainFrame.getInstance().doLoadGenome(null);
                }
            }
        };
        this.genomeComboBox.setMinimumSize(new Dimension(180, 27));
        this.genomeComboBox.setPreferredSize(new Dimension(180, 27));
        this.locationPanel.add((Component)this.genomeComboBox, "fix");
        this.locationPanel.add(Box.createHorizontalStrut(10), "fix");
        this.chromosomeComboBox = new JComboBox();
        this.chromosomeComboBox.setToolTipText("Select a chromosome to view");
        this.chromosomeComboBox.setMaximumSize(new Dimension(120, 35));
        this.chromosomeComboBox.setMinimumSize(new Dimension(120, 27));
        this.chromosomeComboBox.setPreferredSize(new Dimension(120, 16));
        this.chromosomeComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IGVCommandBar.this.chromosomeComboBoxActionPerformed(evt);
            }
        });
        this.locationPanel.add((Component)this.chromosomeComboBox, "fix");
        this.locationPanel.add(Box.createHorizontalStrut(10), "fix");
        this.searchTextField = new SearchTextField();
        this.searchTextField.setToolTipText("Enter a gene of locus, e.f. EGFR,   chr1,   or chr1:100,000-200,000");
        this.searchTextField.setMaximumSize(new Dimension(250, 15));
        this.searchTextField.setMinimumSize(new Dimension(100, 28));
        this.searchTextField.setPreferredSize(new Dimension(250, 28));
        this.searchTextField.setAlignmentY(0.5f);
        this.locationPanel.add((Component)this.searchTextField, "fix");
        this.goButton = new JideButton("Go");
        this.goButton.setToolTipText("Jump to gene or locus");
        this.goButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IGVCommandBar.this.goButtonActionPerformed(evt);
            }
        });
        this.locationPanel.add((Component)this.goButton, "fix");
        this.add((Component)this.locationPanel, "fix");
        this.add(Box.createHorizontalStrut(10), "fix");
        this.toolPanel = new JPanel();
        this.toolPanel.setAlignmentX(1.0f);
        this.toolPanel.setLayout(new JideBoxLayout(this.toolPanel, 0));
        this.homeButton = new JideButton();
        this.homeButton.setAlignmentX(1.0f);
        this.homeButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Home24.gif")));
        this.homeButton.setToolTipText("Jump to whole genome view");
        this.homeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IGVCommandBar.this.homeButtonActionPerformed(evt);
            }
        });
        this.toolPanel.add((Component)this.homeButton, "fix");
        this.refreshButton = new JideButton();
        this.refreshButton.setAlignmentX(1.0f);
        this.refreshButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Refresh24.gif")));
        this.refreshButton.setToolTipText("Refresh the screen");
        this.refreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IGVCommandBar.this.refreshButtonActionPerformed(evt);
            }
        });
        this.toolPanel.add((Component)this.refreshButton, "fix");
        ImageIcon regionOfInterestIcon = IconFactory.getInstance().getIcon(IconFactory.IconID.REGION_OF_INTEREST);
        this.roiToggleButton = new JideToggleButton(regionOfInterestIcon);
        this.roiToggleButton.setAlignmentX(1.0f);
        this.roiToggleButton.setToolTipText("Define a region of interest.");
        this.roiToggleButton.setMaximumSize(new Dimension(32, 32));
        this.roiToggleButton.setMinimumSize(new Dimension(32, 32));
        this.roiToggleButton.setPreferredSize(new Dimension(32, 32));
        this.roiToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IGVCommandBar.this.roiToggleButtonActionPerformed(evt);
            }
        });
        this.toolPanel.add((Component)this.roiToggleButton, "fix");
        this.add(this.toolPanel);
        this.add(Box.createHorizontalGlue(), "vary");
        this.zoomControl = new ZoomSliderPanel();
        this.zoomControl.setPreferredSize(new Dimension(200, 30));
        this.zoomControl.setMinimumSize(new Dimension(200, 30));
        this.zoomControl.setMaximumSize(new Dimension(200, 30));
        this.zoomControl.setToolTipText("Click + to zoom in,  - to zoom out.");
        this.zoomControl.setOpaque(false);
        this.add((Component)this.zoomControl, "fix");
        this.add(Box.createHorizontalStrut(20), "fix");
    }

    public GenomeManager.GenomeListItem getGenomeSelectedInDropdown() {
        return (GenomeManager.GenomeListItem)this.genomeComboBox.getSelectedItem();
    }

    private void adjustChromosomeDropdownWidth(int width) {
        int newWidth = width > 120 ? width : 120;
        this.chromosomeComboBox.setMaximumSize(new Dimension(newWidth, 35));
        this.chromosomeComboBox.setMinimumSize(new Dimension(newWidth, 27));
        this.chromosomeComboBox.setPreferredSize(new Dimension(newWidth, 16));
        this.revalidate();
    }

    private void homeButtonActionPerformed(ActionEvent evt) {
        String chr = this.getViewContext().getHomeChr();
        this.getViewContext().setChromosomeName(chr);
        this.getViewContext().history.push(chr);
        this.chromosomeComboBox.setSelectedItem(chr);
        this.updateCurrentCoordinates();
        this.owner.chromosomeChangeEvent();
        this.owner.repaint();
    }

    private void refreshButtonActionPerformed(ActionEvent evt) {
        LRUCache.clearCaches();
        this.owner.doRefresh();
    }

    private void chromosomeComboBoxActionPerformed(ActionEvent evt) {
        JComboBox combobox = (JComboBox)evt.getSource();
        String chromosomeName = (String)combobox.getSelectedItem();
        if (chromosomeName != null && !chromosomeName.equals(this.getViewContext().getChrName())) {
            this.getViewContext().setChromosomeName(chromosomeName);
            this.getViewContext().recordHistory();
            this.updateCurrentCoordinates();
            this.owner.chromosomeChangeEvent();
            this.owner.repaint();
            PreferenceManager.getInstance().setLastChromosomeViewed(chromosomeName);
        }
    }

    private void goButtonActionPerformed(ActionEvent evt) {
        String searchText = this.getSearchTextField().getText();
        this.searchByLocus(searchText);
    }

    public void searchByLocus(String searchText) {
        if (log.isDebugEnabled()) {
            log.debug("Enter search by locus: " + searchText);
        }
        if (searchText != null && searchText.length() > 0) {
            this.getSearchTextField().setText(searchText);
            new SearchCommand(this.getViewContext(), searchText).execute();
            this.chromosomeComboBox.setSelectedItem(this.getViewContext().getChrName());
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit search by locus: " + searchText);
        }
    }

    private void roiToggleButtonActionPerformed(ActionEvent evt) {
        if (this.roiToggleButton.isSelected()) {
            this.owner.beginROI(this.roiToggleButton);
        } else {
            this.owner.endROI();
        }
    }

    static class SearchTextField
    extends JTextField {
        SearchTextField() {
        }

        public void reshape(int arg0, int arg1, int arg2, int arg3) {
            super.reshape(arg0, arg1, arg2, this.getPreferredSize().height);
        }
    }

    static class ComboBoxRenderer
    implements ListCellRenderer {
        JSeparator separator = new JSeparator(0);

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String text = value == null ? "" : value.toString();
            JLabel renderer = null;
            if ("--SEPARATOR--".equals(text)) {
                return this.separator;
            }
            if (text.equals("Remove Imported Genomes...")) {
                JLabel label = new JLabel(text);
                label.setOpaque(true);
                label.setBorder(new EmptyBorder(1, 1, 1, 1));
                renderer = label;
            } else {
                JLabel label = new JLabel(text);
                label.setOpaque(true);
                label.setBorder(new EmptyBorder(1, 1, 1, 1));
                renderer = label;
            }
            if (isSelected) {
                ((Component)renderer).setBackground(list.getSelectionBackground());
                ((Component)renderer).setForeground(list.getSelectionForeground());
            } else {
                ((Component)renderer).setBackground(list.getBackground());
                ((Component)renderer).setForeground(list.getForeground());
            }
            ((Component)renderer).setFont(list.getFont());
            return renderer;
        }
    }
}

