/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.feature.BEDFileParser;
import org.broad.igv.feature.Feature;
import org.broad.igv.feature.Genome;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.sam.reader.FeatureIndex;
import org.broad.igv.sam.reader.SamUtils;
import org.broad.igv.session.ViewContext;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.ui.WaitCursorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedBEDFeatureSource
implements FeatureSource {
    static Logger log = Logger.getLogger(IndexedBEDFeatureSource.class);
    File bedFile;
    FeatureIndex featureIndex;
    BEDFileParser parser;
    HashMap<String, String> chrMappings = new HashMap();

    public IndexedBEDFeatureSource(File samFile, File indexFile) {
        this.bedFile = samFile;
        if (indexFile.exists()) {
            this.featureIndex = new FeatureIndex(indexFile);
        }
        this.parser = new BEDFileParser();
        this.initChrMap();
    }

    private void initChrMap() {
        Set<String> seqNames;
        Genome genome;
        if (this.featureIndex != null && (genome = ViewContext.getInstance().getGenome()) != null && (seqNames = this.featureIndex.getIndexedChromosomes()) != null) {
            for (String chr : seqNames) {
                String alias = genome.getChromosomeAlias(chr);
                this.chrMappings.put(alias, chr);
            }
        }
    }

    @Override
    public Iterator<Feature> getFeatures(String chr, int start, int end) {
        return this.loadFeatures(chr, start, end).iterator();
    }

    @Override
    public List<LocusScore> getCoverageScores(String chr, int i2, int i1, int zoom) {
        return null;
    }

    @Override
    public int getBinSize() {
        return 0;
    }

    @Override
    public void setBinSize(int size) {
    }

    private FeatureIndex getIndex() {
        if (this.featureIndex == null) {
            this.featureIndex = SamUtils.getIndexFor(this.bedFile.getAbsolutePath());
        }
        return this.featureIndex;
    }

    public Set<String> getSequenceNames() {
        FeatureIndex idx = this.getIndex();
        if (idx == null) {
            return null;
        }
        return idx.getIndexedChromosomes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Feature> loadFeatures(String chr, int start, int end) {
        features = new ArrayList<Feature>();
        if (this.featureIndex == null) {
            this.featureIndex = SamUtils.getIndexFor(this.bedFile.getAbsolutePath());
        }
        if (this.featureIndex == null) {
            throw new UnsupportedOperationException("SAM files must be indexed to support query methods");
        }
        v0 = chrAlias = this.chrMappings.containsKey(chr) != false ? this.chrMappings.get(chr) : chr;
        if (!this.featureIndex.containsChromosome(chrAlias)) {
            return features;
        }
        ct = WaitCursorManager.showWaitCursor();
        try {
            block16: {
                startAdjustment = this.featureIndex.getLongestFeature(chrAlias);
                startTileNumber = Math.max(0, start - startAdjustment) / this.featureIndex.getTileWidth();
                seekPos = this.featureIndex.getTileDef(chrAlias, startTileNumber);
                if (seekPos != null) {
                    is = null;
                    try {
                        try {
                            is = new FileInputStream(this.bedFile);
                            is.getChannel().position(seekPos.getStartPosition());
                            br = new BufferedReader(new InputStreamReader(is));
                            nextLine = "";
                            while ((nextLine = br.readLine()) != null && (f = this.parser.parseLine(tokens = nextLine.split("\t"), tokens.length)).getStart() <= end && f.getChr().equals(chrAlias)) {
                                if (f.getEnd() < start) continue;
                                features.add(f);
                            }
                            var16_16 = null;
                            if (is == null) break block16;
                        }
                        catch (IOException ex) {
                            IndexedBEDFeatureSource.log.error("Error opening sam file", ex);
                            var16_17 = null;
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException e) {}
                            }
                            break block16;
                        }
                    }
                    catch (Throwable var15_22) {
                        var16_18 = null;
                        if (is == null) throw var15_22;
                        ** try [egrp 3[TRYBLOCK] [4 : 323->331)] { 
lbl46:
                        // 1 sources

                        is.close();
                        throw var15_22;
lbl48:
                        // 1 sources

                        catch (IOException e) {
                            // empty catch block
                        }
                        throw var15_22;
                    }
                    try {}
                    catch (IOException e) {}
                    is.close();
                }
            }
            var19_23 = null;
        }
        catch (Throwable var18_25) {
            var19_24 = null;
            WaitCursorManager.removeWaitCursor(ct);
            throw var18_25;
        }
        WaitCursorManager.removeWaitCursor(ct);
        return features;
    }

    public boolean hasIndex() {
        if (this.featureIndex == null) {
            this.featureIndex = SamUtils.getIndexFor(this.bedFile.getAbsolutePath());
        }
        return this.featureIndex != null;
    }
}

