/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.awt.Color;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.data.DataSource;
import org.broad.igv.data.HDFDataManager;
import org.broad.igv.data.HDFDataSource;
import org.broad.igv.feature.Feature;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.h5.ObjectNotFoundException;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.session.ViewContext;
import org.broad.igv.track.DataTrack;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.util.ResourceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HDFDataTrack
extends DataTrack {
    private static Logger log = Logger.getLogger(HDFDataTrack.class);
    private DataSource dataSource;
    int trackNumber;
    private static Color K4_COLOR = new Color(0, 150, 0);
    private static Color K9_COLOR = new Color(100, 0, 0);
    private static Color K27_COLOR = Color.RED;
    private static Color K36_COLOR = new Color(0, 0, 150);
    static List<WindowFunction> wfs = new ArrayList<WindowFunction>();

    public HDFDataTrack(HDFDataManager dataManager, ResourceLocator locator, String name, int trackNumber) throws FileNotFoundException {
        super(locator, name + trackNumber, name);
        this.trackNumber = trackNumber;
        this.dataSource = new HDFDataSource(dataManager, name, trackNumber);
        String chr = ViewContext.getInstance().getChrName();
        float max = (float)this.dataSource.getDataMax();
        float min = Math.min(0.0f, (float)this.dataSource.getDataMin());
        if (min < 0.0f) {
            float absMax = Math.max(Math.abs(max), Math.abs(min));
            min = -absMax;
            max = absMax;
        }
        if (max == min) {
            max += 1.0f;
        }
        float baseline = 0.0f;
        this.setDataRange(new DataRange(min, baseline, max));
        try {
            this.setTrackType(this.dataSource.getTrackType());
        }
        catch (Exception exception) {
            log.error("Unknown track type: " + (Object)((Object)this.dataSource.getTrackType()));
        }
        String tmp = this.getName();
        if (tmp.contains("K4")) {
            this.setColor(K4_COLOR);
        } else if (tmp.contains("K9")) {
            this.setColor(K9_COLOR);
        } else if (tmp.contains("K27")) {
            this.setColor(K27_COLOR);
        } else if (tmp.contains("K36")) {
            this.setColor(K36_COLOR);
        }
    }

    @Override
    public List<LocusScore> getSummaryScores(String chr, int startLocation, int endLocation, int zoom) {
        try {
            return this.dataSource.getSummaryScoresForRange(chr, startLocation, endLocation, zoom);
        }
        catch (ObjectNotFoundException ex) {
            return new ArrayList<LocusScore>();
        }
    }

    @Override
    public WindowFunction getWindowFunction() {
        return this.dataSource.getWindowFunction();
    }

    @Override
    public void setStatType(WindowFunction statType) {
        this.dataSource.setWindowFunction(statType);
    }

    @Override
    public boolean isLogNormalized() {
        return this.dataSource.isLogNormalized();
    }

    @Override
    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType type) {
        if (end <= start) {
            return 0.0f;
        }
        if (this.isRegionScoreType(type)) {
            List<LocusScore> scores = this.getSummaryScores(chr, start, end, zoom);
            float regionScore = 0.0f;
            int intervalSum = 0;
            for (LocusScore score : scores) {
                if (score.getEnd() < start || score.getStart() > end) continue;
                int interval = Math.min(end, score.getEnd()) - Math.max(start, score.getStart());
                float value = score.getScore();
                regionScore += value * (float)interval;
                intervalSum += interval;
            }
            if (intervalSum <= 0) {
                return -3.4028235E38f;
            }
            return type == RegionScoreType.DELETION ? -regionScore : (regionScore /= (float)intervalSum);
        }
        return -3.4028235E38f;
    }

    @Override
    public void refreshData(long timestamp) {
        this.dataSource.refreshData(timestamp);
    }

    public List<List<Feature>> getFeaturesByLevels(String chr, int startLocation, int endLocation) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getNumberOfFeatureLevels() {
        return 1;
    }

    public void setMultiLevelFeatures(boolean isMultiLevel) {
    }

    public boolean isMuliLevelFeatures() {
        return false;
    }

    @Override
    public Collection<WindowFunction> getAvailableWindowFunctions() {
        return wfs;
    }

    static {
        wfs.add(WindowFunction.percentile10);
        wfs.add(WindowFunction.median);
        wfs.add(WindowFunction.mean);
        wfs.add(WindowFunction.percentile90);
        wfs.add(WindowFunction.max);
    }
}

