/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import net.sf.samtools.util.CloseableIterator;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.Genome;
import org.broad.igv.feature.Strand;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.reader.AlignmentQueryReader;
import org.broad.igv.sam.reader.SamQueryReaderFactory;
import org.broad.igv.tools.parsers.DataConsumer;
import org.broad.igv.track.TrackType;

public class CoverageCounter {
    private String alignmentFile;
    private DataConsumer consumer;
    private float[] buffer;
    private int windowSize = 1;
    private int minMappingQuality = 0;
    private int strandOption = -1;
    private int extFactor;
    private int totalCount = 0;
    private File wigFile = null;
    private WigWriter wigWriter = null;
    private Genome genome;

    public CoverageCounter(String alignmentFile, DataConsumer consumer, int windowSize, int extFactor, File wigFile, Genome genome, int strandOption) {
        this.alignmentFile = alignmentFile;
        this.consumer = consumer;
        this.windowSize = windowSize;
        this.extFactor = extFactor;
        this.wigFile = wigFile;
        this.genome = genome;
        this.strandOption = strandOption;
        this.buffer = strandOption < 0 ? new float[1] : new float[2];
    }

    private boolean passFilter(Alignment alignment) {
        if (this.strandOption > 0 && alignment.getFragmentStrand(this.strandOption) == Strand.NONE) {
            return false;
        }
        return alignment.isMapped() && !alignment.isDuplicate() && alignment.getMappingQuality() >= this.minMappingQuality;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void parse() {
        block35: {
            ReadCounter counter;
            CloseableIterator<Alignment> iter;
            AlignmentQueryReader reader;
            block33: {
                int tolerance = (int)((double)this.windowSize * (Math.floor(this.extFactor / this.windowSize) + 2.0));
                this.consumer.setSortTolerance(tolerance);
                reader = null;
                iter = null;
                String lastChr = "";
                counter = null;
                if (this.wigFile != null) {
                    this.wigWriter = new WigWriter(this.wigFile, this.windowSize);
                }
                reader = SamQueryReaderFactory.getReader(this.alignmentFile, false);
                iter = reader.iterator();
                while (iter != null && iter.hasNext()) {
                    AlignmentBlock[] blocks;
                    Alignment alignment = (Alignment)iter.next();
                    if (!this.passFilter(alignment)) continue;
                    ++this.totalCount;
                    String alignmentChr = alignment.getChr();
                    if (alignmentChr.equals(lastChr)) {
                        if (counter != null) {
                            counter.closeBucketsBefore(alignment.getAlignmentStart() - tolerance);
                        }
                    } else {
                        if (counter != null) {
                            counter.closeBucketsBefore(Integer.MAX_VALUE);
                        }
                        counter = new ReadCounter(alignmentChr);
                        lastChr = alignmentChr;
                    }
                    if ((blocks = alignment.getAlignmentBlocks()) != null) {
                        for (AlignmentBlock block : blocks) {
                            int adjustedStart = block.getStart();
                            int adjustedEnd = block.getEnd();
                            if (alignment.isNegativeStrand()) {
                                adjustedStart = Math.max(0, adjustedStart - this.extFactor);
                            } else {
                                adjustedEnd += this.extFactor;
                            }
                            for (int pos = adjustedStart; pos < adjustedEnd; ++pos) {
                                counter.incrementCount(pos);
                            }
                        }
                        continue;
                    }
                    int adjustedStart = alignment.getAlignmentStart();
                    int adjustedEnd = alignment.getAlignmentEnd();
                    if (alignment.isNegativeStrand()) {
                        adjustedStart = Math.max(0, adjustedStart - this.extFactor);
                    } else {
                        adjustedEnd += this.extFactor;
                    }
                    for (int pos = adjustedStart; pos < adjustedEnd; ++pos) {
                        counter.incrementCount(pos);
                    }
                }
                Object var17_18 = null;
                if (counter != null) {
                    counter.closeBucketsBefore(Integer.MAX_VALUE);
                }
                this.consumer.setAttribute("totalCount", String.valueOf(this.totalCount));
                this.consumer.parsingComplete();
                if (reader == null) break block33;
                try {
                    reader.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            if (iter != null) {
                iter.close();
            }
            if (this.wigWriter != null) {
                this.wigWriter.close();
            }
            break block35;
            {
                catch (Exception e3) {
                    e3.printStackTrace();
                    Object var17_19 = null;
                    if (counter != null) {
                        counter.closeBucketsBefore(Integer.MAX_VALUE);
                    }
                    this.consumer.setAttribute("totalCount", String.valueOf(this.totalCount));
                    this.consumer.parsingComplete();
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    if (iter != null) {
                        iter.close();
                    }
                    if (this.wigWriter != null) {
                        this.wigWriter.close();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var17_20 = null;
                if (counter != null) {
                    counter.closeBucketsBefore(Integer.MAX_VALUE);
                }
                this.consumer.setAttribute("totalCount", String.valueOf(this.totalCount));
                this.consumer.parsingComplete();
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                if (iter != null) {
                    iter.close();
                }
                if (this.wigWriter != null) {
                    this.wigWriter.close();
                }
                throw throwable;
            }
        }
    }

    class WigWriter
    implements DataConsumer {
        String lastChr = null;
        int lastPosition = 0;
        int step;
        int span;
        PrintWriter pw;

        WigWriter(File file, int step) throws IOException {
            this.step = step;
            this.span = step;
            this.pw = new PrintWriter(new FileWriter(file));
        }

        public void addData(String chr, int start, int end, float[] data, String name) {
            if (CoverageCounter.this.genome.getChromosome(chr) == null) {
                return;
            }
            if (data[0] == 0.0f || end <= start) {
                return;
            }
            int dataSpan = end - start;
            if (chr == null || !chr.equals(this.lastChr) || dataSpan != this.span) {
                this.span = dataSpan;
                this.outputStepLine(chr, start + 1);
            }
            this.pw.println(start + 1 + "\t" + data[0]);
            this.lastPosition = start;
            this.lastChr = chr;
        }

        private void close() {
            this.pw.close();
        }

        private void outputStepLine(String chr, int start) {
            this.pw.println("variableStep chrom=" + chr + " span=" + this.span);
        }

        public void setType(String type) {
        }

        public void parsingComplete() {
        }

        public void setTrackParameters(TrackType trackType, String trackLine, String[] trackNames) {
        }

        public void setSortTolerance(int tolerance) {
        }

        public void setAttribute(String key, String value) {
        }
    }

    static class Counter {
        int count = 0;
        int negCount = 0;

        Counter() {
        }

        void increment() {
            ++this.count;
        }

        void incrementNeg() {
            ++this.negCount;
        }

        int getCount() {
            return this.count;
        }

        int getNegCount() {
            return this.negCount;
        }
    }

    class ReadCounter {
        String chr;
        TreeMap<Integer, Counter> counts = new TreeMap();

        ReadCounter(String chr) {
            this.chr = chr;
        }

        void incrementCount(int position) {
            Integer bucket = position / CoverageCounter.this.windowSize;
            if (!this.counts.containsKey(bucket)) {
                this.counts.put(bucket, new Counter());
            }
            this.counts.get(bucket).increment();
        }

        void incrementNegCount(int position) {
            Integer bucket = position / CoverageCounter.this.windowSize;
            if (!this.counts.containsKey(bucket)) {
                this.counts.put(bucket, new Counter());
            }
            this.counts.get(bucket).incrementNeg();
        }

        void closeBucketsBefore(int position) {
            ArrayList<Integer> bucketsToClose = new ArrayList<Integer>();
            Integer bucket = position / CoverageCounter.this.windowSize;
            for (Map.Entry<Integer, Counter> entry : this.counts.entrySet()) {
                Chromosome chromosome;
                if (entry.getKey() >= bucket) continue;
                int bucketStartPosition = entry.getKey() * CoverageCounter.this.windowSize;
                int bucketEndPosition = bucketStartPosition + CoverageCounter.this.windowSize;
                if (CoverageCounter.this.genome != null && (chromosome = CoverageCounter.this.genome.getChromosome(this.chr)) != null) {
                    bucketEndPosition = Math.min(bucketEndPosition, chromosome.getLength());
                }
                int bucketSize = bucketEndPosition - bucketStartPosition;
                ((CoverageCounter)CoverageCounter.this).buffer[0] = (float)entry.getValue().getCount() / (float)bucketSize;
                if (CoverageCounter.this.strandOption > 0) {
                    ((CoverageCounter)CoverageCounter.this).buffer[1] = (float)entry.getValue().getCount() / (float)bucketSize;
                }
                CoverageCounter.this.consumer.addData(this.chr, bucketStartPosition, bucketEndPosition, CoverageCounter.this.buffer, null);
                if (CoverageCounter.this.wigWriter != null) {
                    CoverageCounter.this.wigWriter.addData(this.chr, bucketStartPosition, bucketEndPosition, CoverageCounter.this.buffer, null);
                }
                bucketsToClose.add(entry.getKey());
            }
            for (Integer key : bucketsToClose) {
                this.counts.remove(key);
            }
        }
    }
}

