/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tdf;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.broad.igv.tdf.BufferedByteWriter;
import org.broad.igv.tdf.TDFTile;

public class TDFFixedTile
implements TDFTile {
    int tileStart;
    float span;
    int start;
    float[][] data;

    public TDFFixedTile(ByteBuffer byteBuffer, int nSamples) throws IOException {
        this.fill(byteBuffer, nSamples);
    }

    public TDFFixedTile(int tileStart, int start, float span, float[][] data) {
        this.tileStart = tileStart;
        this.span = span;
        this.data = data;
        this.start = start;
    }

    public int getTileStart() {
        return this.start;
    }

    public int getTileEnd() {
        return this.getSize() == 0 ? 0 : this.getEndPosition(this.getSize() - 1);
    }

    public int getStartPosition(int idx) {
        return this.start + (int)((float)idx * this.span);
    }

    public int getEndPosition(int idx) {
        return this.start + (int)((float)(idx + 1) * this.span);
    }

    public String getName(int idx) {
        return null;
    }

    public float getValue(int row, int idx) {
        return this.data[row][idx];
    }

    public int getSize() {
        return this.data == null ? 0 : this.data[0].length;
    }

    public void writeTo(BufferedByteWriter fos) throws IOException {
        fos.putNullTerminatedString(TDFTile.Type.fixedStep.toString());
        fos.putInt(this.getSize());
        fos.putInt(this.start);
        fos.putFloat(this.span);
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            for (int j2 = 0; j2 < this.data[i2].length; ++j2) {
                fos.putFloat(this.data[i2][j2]);
            }
        }
    }

    public void fill(ByteBuffer byteBuffer, int nSamples) throws IOException {
        int nPositions = byteBuffer.getInt();
        this.start = byteBuffer.getInt();
        this.span = byteBuffer.getFloat();
        this.data = new float[nSamples][nPositions];
        for (int sample = 0; sample < nSamples; ++sample) {
            this.data[sample] = new float[nPositions];
            for (int i2 = 0; i2 < nPositions; ++i2) {
                this.data[sample][i2] = byteBuffer.getFloat();
            }
        }
    }
}

