/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tdf;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.broad.igv.tdf.BufferedByteWriter;
import org.broad.igv.tdf.TDFTile;
import org.broad.igv.util.StringUtils;

public class TDFBedTile
implements TDFTile {
    int tileStart;
    int[] start;
    int[] end;
    float[][] data;
    String[] name;

    public TDFBedTile(ByteBuffer byteBuffer, int nSamples, TDFTile.Type type) throws IOException {
        this.fill(byteBuffer, nSamples, type);
    }

    public TDFBedTile(int tileStart, int[] start, int[] end, float[][] data) {
        this.tileStart = tileStart;
        this.start = start;
        this.end = end;
        this.data = data;
    }

    public TDFBedTile(int tileStart, int[] start, int[] end, float[][] data, String[] name) {
        this(tileStart, start, end, data);
        this.name = name;
    }

    public int getSize() {
        return this.start.length;
    }

    public int getTileStart() {
        return this.tileStart;
    }

    public int getTileEnd() {
        return this.getSize() == 0 ? 0 : this.getEndPosition(this.getSize() - 1);
    }

    public int getStartPosition(int idx) {
        return this.start[idx];
    }

    public int getEndPosition(int idx) {
        return this.end[idx];
    }

    public String getName(int idx) {
        return this.name == null ? null : this.name[idx];
    }

    public float getValue(int row, int idx) {
        return this.data[row][idx];
    }

    public void writeTo(BufferedByteWriter fos) throws IOException {
        int i2;
        TDFTile.Type type = this.name == null ? TDFTile.Type.bed : TDFTile.Type.bedWithName;
        fos.putNullTerminatedString(type.toString());
        int nPositions = this.start.length;
        int nSamples = this.data.length;
        fos.putInt(nPositions);
        for (i2 = 0; i2 < nPositions; ++i2) {
            fos.putInt(this.start[i2]);
        }
        for (i2 = 0; i2 < nPositions; ++i2) {
            fos.putInt(this.end[i2]);
        }
        fos.putInt(nSamples);
        for (i2 = 0; i2 < this.data.length; ++i2) {
            for (int j2 = 0; j2 < this.data[i2].length; ++j2) {
                fos.putFloat(this.data[i2][j2]);
            }
        }
        if (type == TDFTile.Type.bedWithName) {
            for (i2 = 0; i2 < nPositions; ++i2) {
                fos.putNullTerminatedString(this.name[i2]);
            }
        }
    }

    private void fill(ByteBuffer byteBuffer, int nSamples, TDFTile.Type type) throws IOException {
        int i2;
        int nPositions = byteBuffer.getInt();
        this.start = new int[nPositions];
        for (i2 = 0; i2 < nPositions; ++i2) {
            this.start[i2] = byteBuffer.getInt();
        }
        this.end = new int[nPositions];
        for (i2 = 0; i2 < nPositions; ++i2) {
            this.end[i2] = byteBuffer.getInt();
        }
        int nS = byteBuffer.getInt();
        assert (nS == nSamples);
        this.data = new float[nS][nPositions];
        for (int row = 0; row < nS; ++row) {
            this.data[row] = new float[nPositions];
            for (int i3 = 0; i3 < nPositions; ++i3) {
                this.data[row][i3] = byteBuffer.getFloat();
            }
        }
        if (type == TDFTile.Type.bedWithName) {
            this.name = new String[nPositions];
            for (int i4 = 0; i4 < nPositions; ++i4) {
                this.name[i4] = StringUtils.readString(byteBuffer);
            }
        }
    }
}

