/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.util.CloseableIterator;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.reader.AlignmentQueryReader;
import org.broad.igv.sam.reader.SamQueryReaderFactory;
import org.broad.igv.util.ResourceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SamListReader
implements AlignmentQueryReader {
    SAMFileHeader header;
    Map<String, ResourceLocator> locators;
    Map<String, AlignmentQueryReader> readers;

    public SamListReader(Map<String, ResourceLocator> locators) {
        this.locators = locators;
        this.readers = new HashMap<String, AlignmentQueryReader>(locators.size());
    }

    @Override
    public void close() throws IOException {
        for (AlignmentQueryReader reader : this.readers.values()) {
            reader.close();
        }
        this.readers.clear();
    }

    @Override
    public SAMFileHeader getHeader() {
        if (this.locators == null || this.locators.size() == 0) {
            return null;
        }
        if (this.header == null) {
            if (this.readers.size() == 0) {
                Map.Entry<String, ResourceLocator> tmp = this.locators.entrySet().iterator().next();
                AlignmentQueryReader firstReader = SamQueryReaderFactory.getReader(tmp.getValue());
                this.readers.put(tmp.getKey(), firstReader);
            }
            this.header = this.readers.values().iterator().next().getHeader();
        }
        return this.header;
    }

    @Override
    public Set<String> getSequenceNames() {
        SAMFileHeader header = this.getHeader();
        if (header == null) {
            return null;
        }
        HashSet<String> seqNames = new HashSet<String>();
        List<SAMSequenceRecord> records = header.getSequenceDictionary().getSequences();
        if (records.size() > 0) {
            for (SAMSequenceRecord rec : header.getSequenceDictionary().getSequences()) {
                String chr = rec.getSequenceName();
                seqNames.add(chr);
            }
        }
        return seqNames;
    }

    @Override
    public CloseableIterator<Alignment> iterator() {
        return null;
    }

    @Override
    public CloseableIterator<Alignment> query(String chr, int start, int end, boolean contained) {
        AlignmentQueryReader reader = this.readers.get(chr);
        if (reader == null) {
            ResourceLocator locator = this.locators.get(chr);
            if (locator == null) {
                return null;
            }
            reader = SamQueryReaderFactory.getReader(locator);
        }
        return reader.query(chr, start, end, contained);
    }

    @Override
    public boolean hasIndex() {
        return true;
    }
}

