/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import com.jidesoft.utils.SwingWorker;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.broad.igv.sam.reader.AlignmentIndexer;
import org.broad.igv.sam.reader.FeatureIndex;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.UIUtilities;
import org.jdesktop.layout.GroupLayout;

public class SamIndexCreatorDialog
extends JDialog {
    File samFile;
    File idxFile;
    IndexWorker worker;
    private JButton cancelButton;
    private JButton goButton;
    private JTextPane introTextPane;
    private JLabel jLabel1;
    private JScrollPane jScrollPane2;
    private JProgressBar progressBar;
    private JLabel timeRemainingLabel;
    static String introText = "An index file for @filename could not be located. An index is required to view alignments in IGV.  Click \"Go\" to create one now.";

    public SamIndexCreatorDialog(Frame parent, boolean modal, File samFile, File idxFile) {
        super(parent, modal);
        this.initComponents();
        this.samFile = samFile;
        this.idxFile = idxFile;
        int timeEst = 1 + (int)Math.ceil((double)samFile.length() / 1.0E9);
        String txt = introText.replace("@filename", samFile.getName()).replace("@time", String.valueOf(timeEst));
        this.introTextPane.setText(txt);
        this.introTextPane.setBorder(BorderFactory.createEmptyBorder());
        this.worker = new IndexWorker();
    }

    public FeatureIndex getIndex() {
        if (this.worker == null || !this.worker.isDone()) {
            return null;
        }
        try {
            return (FeatureIndex)this.worker.get();
        }
        catch (Exception ex) {
            MessageUtils.showMessage(ex.getMessage());
            return null;
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.progressBar = new JProgressBar();
        this.timeRemainingLabel = new JLabel();
        this.goButton = new JButton();
        this.cancelButton = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.introTextPane = new JTextPane();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("Estimated time remaining: ");
        this.goButton.setText("Go");
        this.goButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SamIndexCreatorDialog.this.goButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SamIndexCreatorDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.introTextPane.setBackground(this.getParent().getBackground());
        this.introTextPane.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.introTextPane.setEditable(false);
        this.introTextPane.setText("An index file for [filename goes here] could not be located.  An index is required to view alignments in IGV.  Click \"Go\" to create one now.  This will take approximately [time goes here] to complete.");
        this.introTextPane.setFocusable(false);
        this.jScrollPane2.setViewportView(this.introTextPane);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(30, 30, 30).add(layout.createParallelGroup(1).add(this.jScrollPane2, -2, 343, -2).add(layout.createSequentialGroup().add(this.jLabel1).add(18, 18, 18).add(this.timeRemainingLabel, -2, 103, -2)).add(layout.createParallelGroup(2).add(layout.createSequentialGroup().add(this.cancelButton).add(18, 18, 18).add(this.goButton)).add(this.progressBar, -2, 351, -2))).addContainerGap(26, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().addContainerGap(23, Short.MAX_VALUE).add(this.jScrollPane2, -2, 132, -2).add(35, 35, 35).add(layout.createParallelGroup(3).add(this.jLabel1, -2, 27, -2).add(this.timeRemainingLabel, -2, 16, -2)).addPreferredGap(0).add(this.progressBar, -2, -1, -2).add(18, 18, 18).add(layout.createParallelGroup(3).add(this.goButton).add(this.cancelButton)).addContainerGap()));
        this.pack();
    }

    private void goButtonActionPerformed(ActionEvent evt) {
        if (this.worker.isDone() || this.worker.isCancelled()) {
            this.setVisible(false);
        } else {
            this.goButton.setEnabled(false);
            this.worker.execute();
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        if (this.worker != null) {
            this.worker.cancel(true);
        }
        this.setVisible(false);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                File samFile = new File("/Users/jrobinso/IGV/Sam/30DWM.7.sam");
                File idxFile = new File("/Users/jrobinso/IGV/Sam/30DWM.7.sai");
                SamIndexCreatorDialog dialog = new SamIndexCreatorDialog((Frame)new JFrame(), true, samFile, idxFile);
                dialog.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e2) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    class ProgressListener
    implements PropertyChangeListener {
        private JProgressBar progressBar;

        private ProgressListener() {
        }

        ProgressListener(JProgressBar progressBar) {
            this.progressBar = progressBar;
            this.progressBar.setValue(0);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String strPropertyName = evt.getPropertyName();
            if ("progress".equals(strPropertyName)) {
                this.progressBar.setIndeterminate(false);
                int progress = (Integer)evt.getNewValue();
                this.progressBar.setValue(progress);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class IndexWorker
    extends SwingWorker<FeatureIndex, Void> {
        @Override
        protected FeatureIndex doInBackground() throws Exception {
            AlignmentIndexer indexer = AlignmentIndexer.getInstance(SamIndexCreatorDialog.this.samFile, SamIndexCreatorDialog.this.progressBar, this);
            return indexer.createSamIndex(SamIndexCreatorDialog.this.idxFile, 16000);
        }

        @Override
        protected void done() {
            SamIndexCreatorDialog.this.setVisible(false);
        }

        public void setTimeRemaining(long timeInMillis) {
            final int timeRemaining = (int)(timeInMillis / 60000L);
            UIUtilities.invokeOnEventThread(new Runnable(){

                public void run() {
                    String txt = String.valueOf(timeRemaining) + " minutes";
                    if (timeRemaining == 1) {
                        txt = "1 minute";
                    } else if (timeRemaining < 1) {
                        txt = " < 1 minute";
                    }
                    SamIndexCreatorDialog.this.timeRemainingLabel.setText(txt);
                }
            });
        }
    }
}

