/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import net.sf.samtools.util.AsciiLineReader;
import org.broad.igv.sam.DotAlignedAlignment;
import org.broad.igv.sam.reader.AlignmentParser;
import org.broad.igv.util.ParsingUtils;

public class DotAlignedParser
implements AlignmentParser {
    public static int CHROMOSOME_COLUMN = 0;
    private static int START_COLUMN = 1;
    private static int END_COLUMN = 2;
    private static int STRAND_COLUMN = 3;
    private static int NAME_COLUMN = -1;
    private String[] fields = new String[20];
    boolean bedFormat = false;

    public DotAlignedParser() {
        this.bedFormat = false;
    }

    public DotAlignedParser(boolean bedFormat) {
        this.bedFormat = bedFormat;
        if (bedFormat) {
            STRAND_COLUMN = 5;
            NAME_COLUMN = 3;
        }
    }

    public DotAlignedAlignment readNextRecord(AsciiLineReader reader) {
        String nextLine;
        while ((nextLine = reader.readLine()) != null) {
            DotAlignedAlignment alignment = this.createAlignment(nextLine);
            if (alignment == null) continue;
            return alignment;
        }
        return null;
    }

    private DotAlignedAlignment createAlignment(String nextLine) {
        try {
            int nTokens = ParsingUtils.split(nextLine, this.fields, '\t');
            if (nTokens <= END_COLUMN) {
                System.out.println("Skipping line: " + nextLine);
                return null;
            }
            String chr = this.fields[0];
            int start = Integer.parseInt(this.fields[START_COLUMN]);
            int end = Integer.parseInt(this.fields[END_COLUMN]);
            if (this.bedFormat) {
                boolean isNegative = false;
                String name = "";
                if (nTokens > STRAND_COLUMN) {
                    isNegative = this.fields[STRAND_COLUMN].equals("-");
                }
                if (nTokens > NAME_COLUMN) {
                    name = this.fields[NAME_COLUMN];
                }
                return new DotAlignedAlignment(chr, start, end, isNegative, name);
            }
            boolean isNegative = this.fields[STRAND_COLUMN].equals("-");
            return new DotAlignedAlignment(chr, start, end, isNegative);
        }
        catch (NumberFormatException e2) {
            System.out.println("Skipping line: " + nextLine);
            return null;
        }
    }
}

