/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.samtools.util.SortingCollection;
import org.apache.log4j.Logger;
import org.broad.igv.sam.DotAlignedAlignment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DotAlignedCodec
implements SortingCollection.Codec<DotAlignedAlignment> {
    private static Logger log = Logger.getLogger(DotAlignedCodec.class);
    DataOutputStream outputStream;
    DataInputStream inputStream;

    @Override
    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = new DataOutputStream(outputStream);
    }

    @Override
    public void setInputStream(InputStream inputStream) {
        this.inputStream = new DataInputStream(inputStream);
    }

    @Override
    public void encode(DotAlignedAlignment alignment) {
        try {
            this.outputStream.writeUTF(alignment.getChr());
            this.outputStream.writeInt(alignment.getStart());
            this.outputStream.writeInt(alignment.getEnd());
            this.outputStream.writeBoolean(alignment.isNegativeStrand());
        }
        catch (IOException ex) {
            log.error("Error encoding alignment", ex);
        }
    }

    @Override
    public DotAlignedAlignment decode() {
        try {
            String chr = this.inputStream.readUTF();
            int start = this.inputStream.readInt();
            int end = this.inputStream.readInt();
            boolean negativeStrand = this.inputStream.readBoolean();
            return new DotAlignedAlignment(chr, start, end, negativeStrand);
        }
        catch (EOFException ex) {
            return null;
        }
        catch (IOException ex) {
            log.error("Error decoding alignment", ex);
            return null;
        }
    }

    @Override
    public SortingCollection.Codec<DotAlignedAlignment> clone() {
        DotAlignedCodec other = new DotAlignedCodec();
        return other;
    }
}

