/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.swing.JOptionPane;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.util.CloseableIterator;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.feature.Genome;
import org.broad.igv.feature.SequenceManager;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.EmptyAlignmentIterator;
import org.broad.igv.sam.reader.AlignmentQueryReader;
import org.broad.igv.sam.reader.ReadGroupFilter;
import org.broad.igv.session.ViewContext;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.LRUCache;
import org.broad.igv.util.RuntimeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingQueryReader {
    private static Logger log = Logger.getLogger(CachingQueryReader.class);
    private static Set<WeakReference<CachingQueryReader>> activeReaders = Collections.synchronizedSet(new HashSet());
    private static final int KB = 1000;
    private static final int MITOCHONDRIA_TILE_SIZE = 1000;
    private static int DEFAULT_TILE_SIZE = 16000;
    private static int MAX_TILE_COUNT = 4;
    String cachedChr = "";
    private int tileSize = DEFAULT_TILE_SIZE;
    AlignmentQueryReader reader;
    LRUCache<Integer, AlignmentTile> cache;
    private WeakReference<List<String>> unpairedReadNames;
    private boolean cancel = false;

    private static void cancelReaders() {
        for (WeakReference<CachingQueryReader> readerRef : activeReaders) {
            CachingQueryReader reader = (CachingQueryReader)readerRef.get();
            if (reader == null) continue;
            reader.cancel = true;
        }
        log.debug("Readers canceled");
        activeReaders.clear();
    }

    public CachingQueryReader(AlignmentQueryReader reader) {
        this.reader = reader;
        this.cache = new LRUCache(this, MAX_TILE_COUNT);
        this.tileSize = Math.min(DEFAULT_TILE_SIZE, (int)(PreferenceManager.getInstance().getSAMPreferences().getMaxVisibleRange() * 1000.0f));
        this.unpairedReadNames = new WeakReference(new ArrayList());
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public Set<String> getSequenceNames() {
        return this.reader.getSequenceNames();
    }

    public SAMFileHeader getHeader() throws IOException {
        return this.reader.getHeader();
    }

    public CloseableIterator<Alignment> iterator() {
        return this.reader.iterator();
    }

    public boolean hasIndex() {
        return this.reader.hasIndex();
    }

    public CloseableIterator<Alignment> query(String sequence, int start, int end, List<AlignmentCounts> counts, int maxLevels) {
        int endTile;
        int startTile = (start + 1) / this.getTileSize(sequence);
        List<AlignmentTile> tiles = this.getTiles(sequence, startTile, endTile = end / this.getTileSize(sequence), maxLevels);
        if (tiles.size() == 0) {
            return EmptyAlignmentIterator.getInstance();
        }
        int recordCount = tiles.get(0).getOverlappingRecords().size();
        for (AlignmentTile t : tiles) {
            recordCount += t.getContainedRecords().size();
        }
        ArrayList<Alignment> alignments = new ArrayList<Alignment>(recordCount);
        alignments.addAll(tiles.get(0).getOverlappingRecords());
        for (AlignmentTile t : tiles) {
            alignments.addAll(t.getContainedRecords());
            counts.add(t.getCounts());
        }
        return new TiledIterator(start, end, alignments);
    }

    public List<AlignmentTile> getTiles(String seq, int startTile, int endTile, int maxLevels) {
        if (!seq.equals(this.cachedChr)) {
            this.cache.clear();
            this.cachedChr = seq;
        }
        ArrayList<AlignmentTile> tiles = new ArrayList<AlignmentTile>(endTile - startTile + 1);
        ArrayList<AlignmentTile> tilesToLoad = new ArrayList<AlignmentTile>(endTile - startTile + 1);
        int tileSize = this.getTileSize(seq);
        for (int t = startTile; t <= endTile; ++t) {
            AlignmentTile tile = this.cache.get(t);
            if (tile == null) {
                int start = t * tileSize;
                int end = start + tileSize;
                tile = new AlignmentTile(seq, t, start, end, maxLevels);
            }
            tiles.add(tile);
            if (tile.isLoaded()) {
                if (tilesToLoad.size() > 0 && !this.loadTiles(seq, tilesToLoad)) {
                    return tiles;
                }
                tilesToLoad.clear();
                continue;
            }
            tilesToLoad.add(tile);
        }
        if (tilesToLoad.size() > 0) {
            this.loadTiles(seq, tilesToLoad);
        }
        return tiles;
    }

    private boolean loadTiles(String seq, List<AlignmentTile> tiles) {
        int end;
        assert (tiles.size() > 0);
        PreferenceManager.SAMPreferences prefs = PreferenceManager.getInstance().getSAMPreferences();
        int qualityThreshold = prefs.getQualityThreshold();
        boolean filterFailedReads = prefs.isFilterFailedReads();
        ReadGroupFilter filter = ReadGroupFilter.getFilter();
        boolean showDuplicates = prefs.isShowDuplicates();
        if (log.isDebugEnabled()) {
            int first = tiles.get(0).getTileNumber();
            end = tiles.get(tiles.size() - 1).getTileNumber();
            log.debug("Loading tiles: " + first + "-" + end);
        }
        int start = tiles.get(0).start;
        end = tiles.get(tiles.size() - 1).end;
        CloseableIterator<Alignment> iter = null;
        int alignmentCount = 0;
        try {
            HashMap<String, Alignment> mappedMates = new HashMap<String, Alignment>(1000);
            HashMap<String, Alignment> unmappedMates = new HashMap<String, Alignment>(1000);
            activeReaders.add(new WeakReference<CachingQueryReader>(this));
            iter = this.reader.query(seq, start, end, false);
            int tileSize = this.getTileSize(seq);
            while (iter != null && iter.hasNext()) {
                boolean bl;
                if (this.cancel) {
                    boolean bl2 = false;
                    return bl2;
                }
                Alignment record = (Alignment)iter.next();
                String readName = record.getReadName();
                if (record.isPaired()) {
                    if (record.isMapped()) {
                        if (!record.getMate().isMapped()) {
                            Alignment mate = (Alignment)unmappedMates.get(readName);
                            if (mate == null) {
                                mappedMates.put(readName, record);
                            } else {
                                record.setMateSequence(mate.getReadSequence());
                                unmappedMates.remove(readName);
                                mappedMates.remove(readName);
                            }
                        }
                    } else if (record.getMate().isMapped()) {
                        Alignment mappedMate = (Alignment)mappedMates.get(readName);
                        if (mappedMate == null) {
                            unmappedMates.put(readName, record);
                        } else {
                            mappedMate.setMateSequence(record.getReadSequence());
                            unmappedMates.remove(readName);
                            mappedMates.remove(readName);
                        }
                    }
                }
                if (!record.isMapped() || !showDuplicates && record.isDuplicate() || filterFailedReads && record.isVendorFailedRead() || record.getMappingQuality() < qualityThreshold || filter != null && filter.filterAlignment(record)) continue;
                int aStart = record.getAlignmentStart();
                int aEnd = record.getEnd();
                int idx0 = Math.max(0, (aStart - start) / tileSize);
                int idx1 = Math.min(tiles.size() - 1, (aEnd - start) / tileSize);
                for (int i2 = idx0; i2 <= idx1; ++i2) {
                    AlignmentTile t = tiles.get(i2);
                    t.addRecord(record);
                }
                if (++alignmentCount % 1000 != 0) continue;
                if (this.cancel) {
                    bl = false;
                    return bl;
                }
                IGVMainFrame.getInstance().setStatusBarMessage("Reads loaded: " + alignmentCount);
                if (CachingQueryReader.checkMemory()) continue;
                CachingQueryReader.cancelReaders();
                bl = false;
                return bl;
            }
            for (AlignmentTile t : tiles) {
                t.setLoaded(true);
                this.cache.put(t.getTileNumber(), t);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e2) {
            log.error("Error loading alignment data", e2);
            throw new DataLoadException("", "Error: " + e2.toString());
        }
        finally {
            this.cancel = false;
            activeReaders.remove(this);
            if (iter != null) {
                iter.close();
            }
            IGVMainFrame.getInstance().resetStatusMessage();
        }
    }

    private static synchronized int confirmMaxReadCount(String msg) {
        log.debug("Enter max read count");
        return JOptionPane.showConfirmDialog(null, msg, msg, 0);
    }

    private static synchronized boolean checkMemory() {
        if (RuntimeUtils.getAvailableMemoryFraction() < 0.2) {
            LRUCache.clearCaches();
            System.gc();
            if (RuntimeUtils.getAvailableMemoryFraction() < 0.2) {
                String msg = "Memory is low, reading terminating.";
                MessageUtils.showMessage(msg);
                return false;
            }
        }
        return true;
    }

    public int getTileSize(String chr) {
        if (chr.equals("M") || chr.equals("chrM") || chr.equals("MT") || chr.equals("chrMT")) {
            return 1000;
        }
        return this.tileSize;
    }

    public void clearCache() {
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    public static class AlignmentCounts {
        String genomeId;
        int start;
        int end;
        byte[] reference;
        int[] posA;
        int[] posT;
        int[] posC;
        int[] posG;
        int[] posN;
        int[] negA;
        int[] negT;
        int[] negC;
        int[] negG;
        int[] negN;
        int[] qA;
        int[] qT;
        int[] qC;
        int[] qG;
        int[] qN;
        int[] posTotal;
        int[] negTotal;
        private int[] totalQ;
        private int maxCount = 0;

        public AlignmentCounts(String chr, int start, int end) {
            Genome genome = ViewContext.getInstance().getGenome();
            this.genomeId = genome.getId();
            String chrAlias = genome.getChromosomeAlias(chr);
            this.start = start;
            this.end = end;
            this.reference = SequenceManager.readSequence(this.genomeId, chrAlias, start, end);
            int nPts = end - start;
            this.posA = new int[nPts];
            this.posT = new int[nPts];
            this.posC = new int[nPts];
            this.posG = new int[nPts];
            this.posN = new int[nPts];
            this.posTotal = new int[nPts];
            this.negA = new int[nPts];
            this.negT = new int[nPts];
            this.negC = new int[nPts];
            this.negG = new int[nPts];
            this.negN = new int[nPts];
            this.negTotal = new int[nPts];
            this.qA = new int[nPts];
            this.qT = new int[nPts];
            this.qC = new int[nPts];
            this.qG = new int[nPts];
            this.qN = new int[nPts];
            this.totalQ = new int[nPts];
        }

        public int getTotalCount(int pos) {
            int offset = pos - this.start;
            if (offset < 0 || offset >= this.posA.length) {
                if (log.isDebugEnabled()) {
                    log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
                }
                return 0;
            }
            return this.posTotal[offset] + this.negTotal[offset];
        }

        public int getNegTotal(int pos) {
            int offset = pos - this.start;
            if (offset < 0 || offset >= this.posA.length) {
                if (log.isDebugEnabled()) {
                    log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
                }
                return 0;
            }
            return this.negTotal[offset];
        }

        public int getPosTotal(int pos) {
            int offset = pos - this.start;
            if (offset < 0 || offset >= this.posA.length) {
                if (log.isDebugEnabled()) {
                    log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
                }
                return 0;
            }
            return this.posTotal[offset];
        }

        public int getTotalQuality(int pos) {
            int offset = pos - this.start;
            if (offset < 0 || offset >= this.posA.length) {
                if (log.isDebugEnabled()) {
                    log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
                }
                return 0;
            }
            return this.totalQ[offset];
        }

        public int getAvgQuality(int pos) {
            int count = this.getTotalCount(pos);
            return count == 0 ? 0 : this.getTotalQuality(pos) / count;
        }

        public byte getReference(int pos) {
            if (this.reference == null) {
                return 0;
            }
            int offset = pos - this.start;
            if (offset < 0 || offset >= this.reference.length) {
                if (log.isDebugEnabled()) {
                    log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
                }
                return 0;
            }
            return this.reference[offset];
        }

        public int getCount(int pos, byte b2) {
            int offset = pos - this.start;
            if (offset < 0 || offset >= this.posA.length) {
                if (log.isDebugEnabled()) {
                    log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
                }
                return 0;
            }
            switch (b2) {
                case 65: 
                case 97: {
                    return this.posA[offset] + this.negA[offset];
                }
                case 84: 
                case 116: {
                    return this.posT[offset] + this.negT[offset];
                }
                case 67: 
                case 99: {
                    return this.posC[offset] + this.negC[offset];
                }
                case 71: 
                case 103: {
                    return this.posG[offset] + this.negG[offset];
                }
                case 78: 
                case 110: {
                    return this.posN[offset] + this.negN[offset];
                }
            }
            log.error("Unknown nucleotide: " + b2);
            return 0;
        }

        public int getNegCount(int pos, byte b2) {
            int offset = pos - this.start;
            if (offset < 0 || offset >= this.posA.length) {
                if (log.isDebugEnabled()) {
                    log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
                }
                return 0;
            }
            switch (b2) {
                case 65: 
                case 97: {
                    return this.negA[offset];
                }
                case 84: 
                case 116: {
                    return this.negT[offset];
                }
                case 67: 
                case 99: {
                    return this.negC[offset];
                }
                case 71: 
                case 103: {
                    return this.negG[offset];
                }
                case 78: 
                case 110: {
                    return this.negN[offset];
                }
            }
            log.error("Unknown nucleotide: " + b2);
            return 0;
        }

        public int getPosCount(int pos, byte b2) {
            int offset = pos - this.start;
            if (offset < 0 || offset >= this.posA.length) {
                if (log.isDebugEnabled()) {
                    log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
                }
                return 0;
            }
            switch (b2) {
                case 65: 
                case 97: {
                    return this.posA[offset];
                }
                case 84: 
                case 116: {
                    return this.posT[offset];
                }
                case 67: 
                case 99: {
                    return this.posC[offset];
                }
                case 71: 
                case 103: {
                    return this.posG[offset];
                }
                case 78: 
                case 110: {
                    return this.posN[offset];
                }
            }
            log.error("Unknown nucleotide: " + b2);
            return 0;
        }

        public int getQuality(int pos, byte b2) {
            int offset = pos - this.start;
            if (offset < 0 || offset >= this.posA.length) {
                log.error("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
                return 0;
            }
            switch (b2) {
                case 65: 
                case 97: {
                    return this.qA[offset];
                }
                case 84: 
                case 116: {
                    return this.qT[offset];
                }
                case 67: 
                case 99: {
                    return this.qC[offset];
                }
                case 71: 
                case 103: {
                    return this.qG[offset];
                }
                case 78: 
                case 110: {
                    return this.qN[offset];
                }
            }
            log.error("Unknown nucleotide: " + this.posN);
            return 0;
        }

        public int getAvgQuality(int pos, byte b2) {
            int count = this.getCount(pos, b2);
            return count == 0 ? 0 : this.getQuality(pos, b2) / count;
        }

        void incCounts(Alignment alignment) {
            int start = alignment.getAlignmentStart();
            int end = alignment.getAlignmentEnd();
            AlignmentBlock[] blocks = alignment.getAlignmentBlocks();
            if (blocks != null) {
                for (AlignmentBlock b2 : blocks) {
                    if (b2.isSoftClipped()) continue;
                    this.incCounts(b2, alignment.isNegativeStrand());
                }
            } else {
                for (int pos = start; pos < end; ++pos) {
                    byte q = 0;
                    this.incCount(pos, (byte)110, q, alignment.isNegativeStrand());
                }
            }
        }

        private void incCounts(AlignmentBlock block, boolean isNegativeStrand) {
            int start = block.getStart();
            byte[] bases = block.getBases();
            if (bases != null) {
                for (int i2 = 0; i2 < bases.length; ++i2) {
                    int pos = start + i2;
                    byte q = block.getQuality(i2);
                    byte n2 = bases[i2];
                    this.incCount(pos, n2, q, isNegativeStrand);
                }
            }
        }

        private void incCount(int pos, byte b2, byte q, boolean isNegativeStrand) {
            int offset = pos - this.start;
            if (offset >= 0 && offset < this.posA.length) {
                switch (b2) {
                    case 65: 
                    case 97: {
                        if (isNegativeStrand) {
                            this.negA[offset] = this.negA[offset] + 1;
                        } else {
                            this.posA[offset] = this.posA[offset] + 1;
                        }
                        this.qA[offset] = this.qA[offset] + q;
                        break;
                    }
                    case 84: 
                    case 116: {
                        if (isNegativeStrand) {
                            this.negT[offset] = this.negT[offset] + 1;
                        } else {
                            this.posT[offset] = this.posT[offset] + 1;
                        }
                        this.qT[offset] = this.qT[offset] + q;
                        break;
                    }
                    case 67: 
                    case 99: {
                        if (isNegativeStrand) {
                            this.negC[offset] = this.negC[offset] + 1;
                        } else {
                            this.posC[offset] = this.posC[offset] + 1;
                        }
                        this.qC[offset] = this.qC[offset] + q;
                        break;
                    }
                    case 71: 
                    case 103: {
                        if (isNegativeStrand) {
                            this.negG[offset] = this.negG[offset] + 1;
                        } else {
                            this.posG[offset] = this.posG[offset] + 1;
                        }
                        this.qG[offset] = this.qG[offset] + q;
                        break;
                    }
                    case 78: 
                    case 110: {
                        if (isNegativeStrand) {
                            this.negN[offset] = this.negN[offset] + 1;
                        } else {
                            this.posN[offset] = this.posN[offset] + 1;
                        }
                        this.qN[offset] = this.qN[offset] + q;
                    }
                }
                if (isNegativeStrand) {
                    this.negTotal[offset] = this.negTotal[offset] + 1;
                } else {
                    this.posTotal[offset] = this.posTotal[offset] + 1;
                }
                this.totalQ[offset] = this.totalQ[offset] + q;
                this.maxCount = Math.max(this.posTotal[offset] + this.negTotal[offset], this.maxCount);
            }
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public int[] getTotalQ() {
            return this.totalQ;
        }

        public int getMaxCount() {
            return this.maxCount;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AlignmentTile {
        private boolean loaded = false;
        private List<Alignment> containedRecords;
        private int end;
        private List<Alignment> overlappingRecords;
        private int start;
        private int tileNumber;
        private AlignmentCounts counts;
        int maxDepth;
        int e1;
        private Map<String, Alignment> currentBucket;
        private Map<String, Alignment> currentMates;
        private List<Alignment> overflows;
        private Set<String> pairedReadNames;
        private static final Random RAND = new Random(System.currentTimeMillis());

        AlignmentTile(String chr, int tileNumber, int start, int end, int maxLevels) {
            this.tileNumber = tileNumber;
            this.start = start;
            this.end = end;
            this.containedRecords = new ArrayList<Alignment>(16000);
            this.overlappingRecords = new ArrayList<Alignment>();
            this.counts = new AlignmentCounts(chr, start, end);
            this.maxDepth = maxLevels;
            this.e1 = -1;
            this.currentBucket = new HashMap<String, Alignment>(3 * this.maxDepth);
            this.currentMates = new HashMap<String, Alignment>(3 * this.maxDepth);
            this.pairedReadNames = new HashSet<String>(5 * this.maxDepth);
            this.overflows = new LinkedList<Alignment>();
        }

        public int getTileNumber() {
            return this.tileNumber;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public void addRecord(Alignment record) {
            if (record.getStart() > this.e1) {
                this.emptyBucket();
                this.e1 = record.getEnd();
            } else {
                this.e1 = Math.min(this.e1, record.getEnd());
            }
            String readName = record.getReadName();
            if (!this.currentBucket.containsKey(readName)) {
                this.currentBucket.put(readName, record);
            } else if (!this.currentMates.containsKey(readName)) {
                this.currentMates.put(readName, record);
            } else {
                this.overflows.add(record);
            }
            this.counts.incCounts(record);
        }

        private void emptyBucket() {
            List<Alignment> sampledRecords = this.sampleCurrentBucket();
            for (Alignment alignment : sampledRecords) {
                int aStart = alignment.getAlignmentStart();
                int aEnd = alignment.getEnd();
                if (aStart >= this.start && aStart < this.end) {
                    this.containedRecords.add(alignment);
                    continue;
                }
                if (aEnd < this.start || aStart >= this.start) continue;
                this.overlappingRecords.add(alignment);
            }
            this.currentBucket.clear();
            this.currentMates.clear();
            this.overflows.clear();
        }

        private List<Alignment> sampleCurrentBucket() {
            ArrayList<Alignment> sampledList = new ArrayList<Alignment>(this.maxDepth);
            if (this.currentBucket.size() + this.currentMates.size() + this.overflows.size() < this.maxDepth) {
                sampledList.addAll(this.currentBucket.values());
                sampledList.addAll(this.currentMates.values());
                sampledList.addAll(this.overflows);
            } else {
                ArrayList<String> added = new ArrayList<String>(this.pairedReadNames.size());
                for (String readName : this.pairedReadNames) {
                    if (!this.currentBucket.containsKey(readName)) continue;
                    sampledList.add(this.currentBucket.get(readName));
                    this.currentBucket.remove(readName);
                    added.add(readName);
                }
                this.pairedReadNames.removeAll(added);
                LinkedList<String> keys = new LinkedList<String>(this.currentBucket.keySet());
                while (sampledList.size() < this.maxDepth && keys.size() > 0) {
                    String key = (String)keys.remove(RAND.nextInt(keys.size()));
                    Alignment a2 = this.currentBucket.remove(key);
                    sampledList.add(a2);
                    if (!a2.isPaired() || !a2.getMate().isMapped()) continue;
                    Alignment m2 = this.currentMates.remove(key);
                    if (m2 != null) {
                        sampledList.add(m2);
                        continue;
                    }
                    this.pairedReadNames.add(key);
                }
                while (sampledList.size() < this.maxDepth && this.overflows.size() > 0) {
                    sampledList.add(this.overflows.remove(RAND.nextInt(this.overflows.size())));
                }
                Collections.sort(sampledList, new Comparator<Alignment>(){

                    @Override
                    public int compare(Alignment alignment, Alignment alignment1) {
                        return alignment.getStart() - alignment1.getStart();
                    }
                });
            }
            return sampledList;
        }

        public List<Alignment> getContainedRecords() {
            return this.containedRecords;
        }

        public List<Alignment> getOverlappingRecords() {
            return this.overlappingRecords;
        }

        public boolean isLoaded() {
            return this.loaded;
        }

        public void setLoaded(boolean loaded) {
            this.loaded = loaded;
            if (loaded) {
                this.emptyBucket();
                this.currentBucket = null;
                this.currentMates = null;
                this.pairedReadNames = null;
                this.overflows = null;
            }
        }

        public AlignmentCounts getCounts() {
            return this.counts;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TiledIterator
    implements CloseableIterator<Alignment> {
        Iterator<Alignment> currentSamIterator;
        int end;
        Alignment nextRecord;
        int start;
        List<Alignment> alignments;

        TiledIterator(int start, int end, List<Alignment> alignments) {
            this.alignments = alignments;
            this.start = start;
            this.end = end;
            this.currentSamIterator = alignments.iterator();
            this.advanceToFirstRecord();
        }

        @Override
        public void close() {
        }

        @Override
        public boolean hasNext() {
            return this.nextRecord != null;
        }

        @Override
        public Alignment next() {
            Alignment ret = this.nextRecord;
            this.advanceToNextRecord();
            return ret;
        }

        @Override
        public void remove() {
        }

        private void advanceToFirstRecord() {
            this.advanceToNextRecord();
        }

        private void advanceToNextRecord() {
            this.advance();
            while (this.nextRecord != null && this.nextRecord.getEnd() < this.start) {
                this.advance();
            }
        }

        private void advance() {
            if (this.currentSamIterator.hasNext()) {
                this.nextRecord = this.currentSamIterator.next();
                if (this.nextRecord.getAlignmentStart() > this.end) {
                    this.nextRecord = null;
                }
            } else {
                this.nextRecord = null;
            }
        }
    }
}

