/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.awt.Color;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.Strand;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.AlignmentRenderer;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.track.WindowFunction;

public class DotAlignedAlignment
implements Alignment {
    String readName;
    private String chromosome;
    private int start;
    private int end;
    boolean negativeStrand;

    public DotAlignedAlignment(String chromosome, int start, int end, boolean isNegative, String name) {
        this.negativeStrand = isNegative;
        this.readName = name;
        this.chromosome = chromosome;
        this.start = start;
        this.end = end;
    }

    public DotAlignedAlignment(String chromosome, int start, int end, boolean negativeStrand) {
        this.readName = chromosome + ":" + (start + 1) + "-" + (end + 1) + "(" + (negativeStrand ? "-" : "+") + ")";
        this.chromosome = chromosome;
        this.start = start;
        this.end = end;
        this.negativeStrand = negativeStrand;
    }

    public String getReadName() {
        return this.readName;
    }

    public String getReadSequence() {
        return "";
    }

    public void setMateSequence(String sequnce) {
    }

    public String getPairOrientation() {
        return "";
    }

    public boolean isSmallInsert() {
        return false;
    }

    public boolean isVendorFailedRead() {
        return false;
    }

    public Color getDefaultColor() {
        return AlignmentRenderer.grey1;
    }

    public String getChromosome() {
        return this.chromosome;
    }

    public String getChr() {
        return this.chromosome;
    }

    public int getAlignmentStart() {
        return this.getStart();
    }

    public boolean contains(double location) {
        return location >= (double)this.getStart() && location < (double)this.getEnd();
    }

    public AlignmentBlock[] getAlignmentBlocks() {
        return null;
    }

    public AlignmentBlock[] getInsertions() {
        return null;
    }

    public String getCigarString() {
        return "*";
    }

    public int getInferredInsertSize() {
        return 0;
    }

    public int getMappingQuality() {
        return 255;
    }

    public ReadMate getMate() {
        return null;
    }

    public boolean isProperPair() {
        return true;
    }

    public boolean isMapped() {
        return true;
    }

    public boolean isPaired() {
        return false;
    }

    public boolean isNegativeStrand() {
        return this.negativeStrand;
    }

    public boolean isDuplicate() {
        return false;
    }

    public float getScore() {
        return 1.0f;
    }

    public void setConfidence(float confidence) {
    }

    public float getConfidence() {
        return 1.0f;
    }

    public LocusScore copy() {
        return this;
    }

    public String getValueString(double position, WindowFunction windowFunction) {
        return this.readName + "<br>Read length = " + (this.getEnd() - this.getStart());
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getAlignmentEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public byte getBase(double position) {
        return 0;
    }

    public byte getPhred(double position) {
        return 0;
    }

    public String getSample() {
        return null;
    }

    public String getReadGroup() {
        return null;
    }

    public Object getAttribute(String key) {
        return null;
    }

    public Strand getFragmentStrand(int readPair) {
        return Strand.NONE;
    }

    public char[] getGapTypes() {
        return null;
    }
}

