/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.SequenceManager;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.reader.CachingQueryReader;
import org.broad.igv.session.ViewContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlignmentInterval
extends Locus {
    private static Logger log = Logger.getLogger(AlignmentInterval.class);
    private List<Row> alignmentRows;
    List<CachingQueryReader.AlignmentCounts> counts;
    String genomeId;
    byte[] reference;
    int maxCount = 0;

    public AlignmentInterval(String genomeId, String chr, int start, int end, List<Row> rows, List<CachingQueryReader.AlignmentCounts> counts) {
        super(chr, start, end);
        this.genomeId = genomeId;
        this.alignmentRows = rows;
        this.reference = SequenceManager.readSequence(this.genomeId, chr, start, end);
        this.counts = counts;
        for (CachingQueryReader.AlignmentCounts c2 : counts) {
            this.maxCount = Math.max(this.maxCount, c2.getMaxCount());
        }
    }

    boolean contains(String genomeId, String chr, int start, int end) {
        return this.genomeId.equals(genomeId) && super.contains(chr, start, end);
    }

    boolean overlaps(String genomeId, String chr, int start, int end) {
        return this.genomeId.equals(genomeId) && this.overlaps(chr, start, end);
    }

    public int getDepth() {
        return this.alignmentRows.size();
    }

    static Alignment getFeatureContaining(List<Alignment> features, int right) {
        int leftBounds = 0;
        int rightBounds = features.size() - 1;
        int idx = features.size() / 2;
        int lastIdx = -1;
        while (idx != lastIdx) {
            lastIdx = idx;
            Alignment f2 = features.get(idx);
            if (f2.contains(right)) {
                return f2;
            }
            if (f2.getStart() > right) {
                rightBounds = idx;
                idx = (leftBounds + idx) / 2;
                continue;
            }
            leftBounds = idx;
            idx = (rightBounds + idx) / 2;
        }
        if (features.get(0).contains(right)) {
            return features.get(0);
        }
        if (features.get(rightBounds).contains(right)) {
            return features.get(rightBounds);
        }
        return null;
    }

    public List<Row> getAlignmentRows() {
        return this.alignmentRows;
    }

    public void setAlignmentRows(List<Row> alignmentRows) {
        this.alignmentRows = alignmentRows;
    }

    public void sortRows(AlignmentTrack.SortOption option) {
        double center = ViewContext.getInstance().getCenter();
        this.sortRows(option, center);
    }

    public void sortRows(AlignmentTrack.SortOption option, double location) {
        if (this.alignmentRows == null) {
            return;
        }
        for (Row row : this.alignmentRows) {
            if (option == AlignmentTrack.SortOption.NUCELOTIDE) {
                // empty if block
            }
            row.updateScore(option, location, this);
        }
        Collections.sort(this.alignmentRows, new Comparator<Row>(){

            @Override
            public int compare(Row arg0, Row arg1) {
                if (arg0.getScore() > arg1.getScore()) {
                    return 1;
                }
                if (arg0.getScore() > arg1.getScore()) {
                    return -1;
                }
                return 0;
            }
        });
    }

    public byte getReference(int pos) {
        if (this.reference == null) {
            return 0;
        }
        int offset = pos - this.start;
        if (offset < 0 || offset >= this.reference.length) {
            if (log.isDebugEnabled()) {
                log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
            }
            return 0;
        }
        return this.reference[offset];
    }

    public int getCount(int pos, byte b2) {
        for (CachingQueryReader.AlignmentCounts c2 : this.counts) {
            if (pos < c2.getStart() || pos >= c2.getEnd()) continue;
            return c2.getCount(pos, b2);
        }
        return 0;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public int getTotalCount(int pos) {
        for (CachingQueryReader.AlignmentCounts c2 : this.counts) {
            if (pos < c2.getStart() || pos >= c2.getEnd()) continue;
            return c2.getTotalCount(pos);
        }
        return 0;
    }

    public int getNegCount(int pos, byte b2) {
        for (CachingQueryReader.AlignmentCounts c2 : this.counts) {
            if (pos < c2.getStart() || pos >= c2.getEnd()) continue;
            return c2.getNegCount(pos, b2);
        }
        return 0;
    }

    public int getPosCount(int pos, byte b2) {
        for (CachingQueryReader.AlignmentCounts c2 : this.counts) {
            if (pos < c2.getStart() || pos >= c2.getEnd()) continue;
            return c2.getPosCount(pos, b2);
        }
        return 0;
    }

    public static class Row {
        int nextIdx = 0;
        private double score = 0.0;
        List<Alignment> alignments = new ArrayList<Alignment>(100);
        private int start;
        private int lastEnd;

        public void addAlignment(Alignment alignment) {
            if (this.alignments.isEmpty()) {
                this.start = alignment.getStart();
            }
            this.alignments.add(alignment);
            this.lastEnd = alignment.getEnd();
        }

        public void updateScore(AlignmentTrack.SortOption option, double center, AlignmentInterval interval) {
            int adjustedCenter = (int)center;
            Alignment centerAlignment = AlignmentInterval.getFeatureContaining(this.alignments, adjustedCenter);
            if (centerAlignment == null) {
                this.setScore(Double.MAX_VALUE);
            } else {
                switch (option) {
                    case START: {
                        this.setScore(centerAlignment.getStart());
                        break;
                    }
                    case STRAND: {
                        this.setScore(centerAlignment.isNegativeStrand() ? -1.0 : 1.0);
                        break;
                    }
                    case NUCELOTIDE: {
                        byte base = centerAlignment.getBase(adjustedCenter);
                        byte ref = interval.getReference(adjustedCenter);
                        if (base == 78 || base == 110) {
                            this.setScore(2.147483646E9);
                            break;
                        }
                        if (base == ref) {
                            this.setScore(2.147483647E9);
                            break;
                        }
                        int count = interval.getCount(adjustedCenter, base);
                        byte phred = centerAlignment.getPhred(adjustedCenter);
                        float score = -((float)count + (float)phred / 100.0f);
                        this.setScore(score);
                        break;
                    }
                    case QUALITY: {
                        this.setScore(-centerAlignment.getMappingQuality());
                        break;
                    }
                    case SAMPLE: {
                        String sample = centerAlignment.getSample();
                        this.score = sample == null ? 0.0 : (double)sample.hashCode();
                        this.setScore(this.score);
                        break;
                    }
                    case READ_GROUP: {
                        String readGroup = centerAlignment.getReadGroup();
                        this.score = readGroup == null ? 0.0 : (double)readGroup.hashCode();
                        this.setScore(this.score);
                    }
                }
            }
        }

        public Alignment nextAlignment() {
            if (this.nextIdx < this.alignments.size()) {
                Alignment tmp = this.alignments.get(this.nextIdx);
                ++this.nextIdx;
                return tmp;
            }
            return null;
        }

        public int getNextStartPos() {
            if (this.nextIdx < this.alignments.size()) {
                return this.alignments.get(this.nextIdx).getStart();
            }
            return Integer.MAX_VALUE;
        }

        public boolean hasNext() {
            return this.nextIdx < this.alignments.size();
        }

        public void resetIdx() {
            this.nextIdx = 0;
        }

        public double getScore() {
            return this.score;
        }

        public void setScore(double score) {
            this.score = score;
        }

        public int getStart() {
            return this.start;
        }

        public int getLastEnd() {
            return this.lastEnd;
        }
    }
}

