/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.renderer;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.List;
import org.broad.igv.data.rnai.RNAIGeneScore;
import org.broad.igv.data.rnai.RNAIHairpinValue;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.XYPlotRenderer;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RNAiBarChartRenderer
extends XYPlotRenderer {
    private static Color DEFAULT_COLOR = new Color(0, 0, 150);

    @Override
    public void renderScores(Track track, List<LocusScore> locusScores, RenderContext context, Rectangle trackRect) {
        double buffer = Math.min(trackRect.getHeight() * 0.2, 10.0);
        Rectangle drawingRect = new Rectangle(trackRect);
        drawingRect.y = (int)(trackRect.getY() + buffer);
        drawingRect.height = (int)((double)trackRect.height - ((double)drawingRect.y - trackRect.getY()));
        double origin = context.getOrigin();
        double locScale = context.getScale();
        DEFAULT_COLOR = new Color(94, 145, 201);
        DataRange axisDefinition = track.getDataRange();
        int baseY = this.computeYPixelValue(drawingRect, axisDefinition, axisDefinition.getBaseline());
        for (LocusScore score : locusScores) {
            double dx;
            RNAIGeneScore rnaiScore = (RNAIGeneScore)score;
            double pX = ((double)score.getStart() - origin) / locScale;
            if (!(pX + (dx = Math.ceil((double)(score.getEnd() - score.getStart()) / locScale) + 1.0) >= 0.0) || !(pX <= drawingRect.getMaxX())) continue;
            float dataY = score.getScore();
            if (!Float.isNaN(dataY)) {
                int pY = this.computeYPixelValue(drawingRect, axisDefinition, dataY);
                this.drawDataPoint(new Color(57, 67, 201), (int)dx, (int)pX, baseY, pY, context);
            }
            if (rnaiScore.getHairpinValues() == null) continue;
            for (RNAIHairpinValue hValue : rnaiScore.getHairpinValues()) {
                int scoreY = this.computeYPixelValue(drawingRect, axisDefinition, hValue.getScoreMean());
                context.getGraphic2DForColor(new Color(95, 120, 200).brighter()).drawLine((int)pX, scoreY, (int)pX + (int)dx - 1, scoreY);
            }
        }
    }

    @Override
    protected void drawDataPoint(Color graphColor, int dx, int pX, int baseY, int pY, RenderContext context) {
        if (pY > baseY) {
            context.getGraphic2DForColor(graphColor).fillRect(pX, baseY, dx, pY - baseY);
        } else {
            context.getGraphic2DForColor(graphColor).fillRect(pX, pY, dx, baseY - pY);
        }
    }

    @Override
    public Color getDefaultColor() {
        return DEFAULT_COLOR;
    }

    @Override
    public String getDisplayName() {
        return "RNAi BarChart";
    }
}

