/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.renderer;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.feature.Cytoband;
import org.broad.igv.session.ViewContext;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGVMainFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CytobandRenderer {
    boolean drawLabels = true;
    public static final int CYTOBAND_Y_OFFSET = 5;
    public static final int LABEL_OFFSET = 25;
    private static Map<Integer, Color> stainColors = new HashMap<Integer, Color>();

    public void draw(List<Cytoband> data, Graphics g2D, Rectangle graphicRect) {
        if (data.size() > 0) {
            String locus;
            if (IGVMainFrame.getInstance().isExportingSnapshot() && (locus = IGVMainFrame.getInstance().getDisplayedLocusString()) != null) {
                Graphics g2 = g2D.create();
                g2.setFont(FontManager.getScalableFont(1, 10));
                g2.drawString(locus, 3, 11);
            }
            this.drawBands(data, g2D, graphicRect);
            if (this.drawLabels) {
                this.drawLabels(g2D, graphicRect);
            }
        }
    }

    public void drawBands(List<Cytoband> data, Graphics g2D, Rectangle graphicRect) {
        int[] xC = new int[3];
        int[] yC = new int[3];
        double scale = graphicRect.getWidth() / (double)this.getViewContext().getChromosomeLength();
        for (Cytoband cytoband : data) {
            int start = (int)(graphicRect.getX() + scale * (double)cytoband.getStart());
            int end = (int)(graphicRect.getX() + scale * (double)cytoband.getEnd());
            int y = (int)graphicRect.getY() + 5;
            int height = (int)graphicRect.getHeight();
            if (cytoband.getType() == 'c') {
                int center = y + height / 2;
                if (cytoband.getName().startsWith("p")) {
                    xC[0] = start;
                    yC[0] = (int)graphicRect.getMaxY() + 5;
                    xC[1] = start;
                    yC[1] = y;
                    xC[2] = end;
                    yC[2] = center;
                } else {
                    xC[0] = end;
                    yC[0] = (int)graphicRect.getMaxY() + 5;
                    xC[1] = end;
                    yC[1] = y;
                    xC[2] = start;
                    yC[2] = center;
                }
                g2D.setColor(Color.RED.darker());
                g2D.fillPolygon(xC, yC, 3);
                continue;
            }
            g2D.setColor(CytobandRenderer.getCytobandColor(cytoband));
            g2D.fillRect(start, y, end - start, height);
            g2D.setColor(Color.BLACK);
            g2D.drawRect(start, y, end - start, height);
        }
    }

    private void drawLabels(Graphics g2, Rectangle graphicRect) {
        double width = graphicRect.getWidth();
        int y = (int)graphicRect.getY() + 25;
        g2.setColor(Color.BLACK);
        FontMetrics fm = g2.getFontMetrics();
        int minSpacing = 10;
        int prevEnd = 0;
        double sc = width / (double)this.getViewContext().getChromosomeLength();
        int adjustedY = y;
        for (Cytoband cytoband : this.getViewContext().getChromosome().getCytobands()) {
            int stringWidth;
            int e2;
            int s = (int)(sc * (double)cytoband.getStart());
            int x = s + ((e2 = (int)(sc * (double)cytoband.getEnd())) - s - (stringWidth = (int)fm.getStringBounds(cytoband.getName(), g2).getWidth())) / 2;
            if (x <= prevEnd + minSpacing) continue;
            g2.drawString(cytoband.getName(), x, adjustedY);
            prevEnd = x + stringWidth;
        }
    }

    private ViewContext getViewContext() {
        return ViewContext.getInstance();
    }

    public void applyTextTranslationAndRotation(Graphics2D graphics2, int x, int y) {
        AffineTransform transform = new AffineTransform();
        transform.translate(x, y);
        transform.rotate(-1.5707963267948966);
        graphics2.transform(transform);
    }

    private static Color getCytobandColor(Cytoband data) {
        if (data.getType() == 'p') {
            short stain = data.getStain();
            int shade = (int)(255.0 - (double)stain / 100.0 * 255.0);
            Color c2 = stainColors.get(shade);
            if (c2 == null) {
                c2 = new Color(shade, shade, shade);
                stainColors.put(shade, c2);
            }
            return c2;
        }
        if (data.getType() == 'c') {
            return Color.PINK;
        }
        return Color.WHITE;
    }
}

