/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.maf.conservation;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.util.AsciiLineReader;
import org.broad.igv.util.ParsingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OmegaFileParser {
    public void getDataAsScores(File f2, List<LocusScore> scores) {
        AsciiLineReader reader = null;
        try {
            String[] buffer = new String[5];
            reader = new AsciiLineReader(new FileInputStream(f2));
            String nextLine = null;
            while ((nextLine = reader.readLine()) != null) {
                ParsingUtils.split(nextLine, buffer, '\t');
                int position = Integer.parseInt(buffer[0]) + 6;
                float score = Float.parseFloat(buffer[4]);
                scores.add(new OmegaScore(position, score));
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Error parsing file: " + f2.getAbsolutePath(), ex);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public void getDataAsArrays(File f2, int[] locations, float[] data, int offset, int start, int end) {
        AsciiLineReader reader = null;
        try {
            String[] buffer = new String[5];
            reader = new AsciiLineReader(new FileInputStream(f2));
            String nextLine = null;
            int idx = offset;
            while ((nextLine = reader.readLine()) != null) {
                ParsingUtils.split(nextLine, buffer, '\t');
                int s = Integer.parseInt(buffer[0]) + 6;
                if (s >= start) {
                    locations[idx] = s;
                    data[idx] = Float.parseFloat(buffer[4]);
                    continue;
                }
                if (s <= end) continue;
                return;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Error parsing file: " + f2.getAbsolutePath(), ex);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public static class OmegaScore
    implements LocusScore {
        int position;
        float score;

        public OmegaScore(int position, float score) {
            this.position = position;
            this.score = score;
        }

        public String getChr() {
            return null;
        }

        public int getStart() {
            return this.position;
        }

        public void setStart(int start) {
            throw new UnsupportedOperationException("setStart is not supported.");
        }

        public int getEnd() {
            return this.position + 1;
        }

        public void setEnd(int end) {
            throw new UnsupportedOperationException("setEnd is not supported");
        }

        public float getScore() {
            return this.score;
        }

        public void setConfidence(float confidence) {
            throw new UnsupportedOperationException("setConfidence is not supported yet.");
        }

        public float getConfidence() {
            return 1.0f;
        }

        public LocusScore copy() {
            return new OmegaScore(this.position, this.score);
        }

        public String getValueString(double position, WindowFunction windowFunction) {
            return String.valueOf("Omega score = " + this.score);
        }
    }
}

