/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.dranger;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.exceptions.ParserException;
import org.broad.igv.feature.Feature;
import org.broad.igv.feature.Genome;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.dranger.DRangerFeature;
import org.broad.igv.feature.dranger.DRangerRenderer;
import org.broad.igv.session.ViewContext;
import org.broad.igv.track.FeatureCollectionSource;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.util.AsciiLineReader;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DRangerParser {
    int numColumn;
    int chr1Column;
    int str1Column;
    int pos1Column;
    int chr2Column;
    int str2Column;
    int pos2Column;
    int tumreadsColumn;
    int normreadsColumn;
    int classColumn;
    int spanColumn;
    int site1Column;
    int site2Column;
    int qualityColumn;
    int scoreColumn;
    static Logger log = Logger.getLogger(DRangerParser.class);

    public List<FeatureTrack> loadTracks(ResourceLocator locator) {
        String[] tokens = new String[100];
        ArrayList<FeatureTrack> tracks = new ArrayList<FeatureTrack>();
        AsciiLineReader reader = null;
        ArrayList<Feature> features = new ArrayList<Feature>(5000);
        int parseColumn = -1;
        String nextLine = null;
        try {
            Genome genome = ViewContext.getInstance().getGenome();
            reader = ParsingUtils.openAsciiReader(locator);
            this.setColumns(reader.readLine());
            while ((nextLine = reader.readLine()) != null) {
                int nTokens = ParsingUtils.split(nextLine, tokens, '\t');
                if (nTokens <= this.pos2Column) continue;
                int index = Integer.parseInt(tokens[this.numColumn]);
                String chr1 = genome.getChromosomeAlias(tokens[this.chr1Column]);
                int pos1 = Integer.parseInt(tokens[this.pos1Column]);
                String str1 = tokens[this.str1Column];
                Strand strand1 = str1.equals("0") || str1.equals("(+)") ? Strand.POSITIVE : Strand.NEGATIVE;
                String chr2 = genome.getChromosomeAlias(tokens[this.chr2Column]);
                int pos2 = Integer.parseInt(tokens[this.pos2Column]);
                String str2 = tokens[this.str2Column];
                Strand strand2 = str2.equals("0") || str2.equals("(+)") ? Strand.POSITIVE : Strand.NEGATIVE;
                DRangerFeature feature = new DRangerFeature(chr1, pos1, strand1, chr2, pos2, strand2);
                feature.setIndex(index);
                if (this.tumreadsColumn > 0) {
                    feature.setTumreads(this.toInt(tokens[this.tumreadsColumn]));
                }
                if (this.normreadsColumn > 0) {
                    feature.setNormreads(this.toInt(tokens[this.normreadsColumn]));
                }
                if (this.classColumn > 0) {
                    feature.setFeatureClass(tokens[this.classColumn]);
                }
                if (this.spanColumn > 0) {
                    feature.setSpan(this.toInt(tokens[this.spanColumn]));
                }
                if (this.site1Column > 0) {
                    feature.setSite1(tokens[this.site1Column]);
                }
                if (this.site2Column > 0) {
                    feature.setSite2(tokens[this.site2Column]);
                }
                if (this.qualityColumn > 0) {
                    feature.setQuality(this.toInt(tokens[this.qualityColumn]));
                }
                if (this.scoreColumn > 0) {
                    feature.setScore(this.toInt(tokens[this.scoreColumn]));
                }
                features.add(feature);
            }
        }
        catch (NumberFormatException ne) {
            throw new ParserException("Column " + parseColumn + " must be a numeric value", reader.getCurrentLineNumber(), nextLine);
        }
        catch (Exception e2) {
            log.error("Error parsing dRanger file", e2);
            if (nextLine != null && reader.getCurrentLineNumber() != 0L) {
                throw new ParserException(e2.getMessage(), (Throwable)e2, reader.getCurrentLineNumber(), nextLine);
            }
            throw new RuntimeException(e2);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        FeatureTrack track = new FeatureTrack(locator, (FeatureSource)new FeatureCollectionSource(features));
        track.setName(locator.getTrackName());
        track.setRendererClass(DRangerRenderer.class);
        tracks.add(track);
        return tracks;
    }

    private int toInt(String token) {
        try {
            return Integer.parseInt(token);
        }
        catch (NumberFormatException e2) {
            return 0;
        }
    }

    private void setColumns(String header) throws Exception {
        String[] tokens = header.split("\t");
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i2 = 0; i2 < tokens.length; ++i2) {
            map.put(tokens[i2].toLowerCase(), i2);
        }
        this.chr1Column = (Integer)map.get("chr1");
        this.str1Column = (Integer)map.get("str1");
        this.pos1Column = (Integer)map.get("pos1");
        this.chr2Column = (Integer)map.get("chr2");
        this.str2Column = (Integer)map.get("str2");
        this.pos2Column = (Integer)map.get("pos2");
        if (map.containsKey("num")) {
            this.numColumn = (Integer)map.get("num");
        }
        if (map.containsKey("tumreads")) {
            this.tumreadsColumn = (Integer)map.get("tumreads");
        }
        if (map.containsKey("normreads")) {
            this.tumreadsColumn = (Integer)map.get("normreads");
        }
        if (map.containsKey("class")) {
            this.classColumn = (Integer)map.get("class");
        }
        if (map.containsKey("span")) {
            this.spanColumn = (Integer)map.get("span");
        }
        if (map.containsKey("site1")) {
            this.site1Column = (Integer)map.get("site1");
        }
        if (map.containsKey("site2")) {
            this.site2Column = (Integer)map.get("site2");
        }
        if (map.containsKey("quality")) {
            this.qualityColumn = (Integer)map.get("quality");
        }
        if (map.containsKey("score")) {
            this.scoreColumn = (Integer)map.get("score");
        }
    }
}

