/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.broad.igv.feature.GenomeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenomeZipDescriptor
extends GenomeDescriptor {
    private Map<String, ZipEntry> zipEntries;
    private ZipFile genomeZipFile;
    private boolean userDefined;

    public GenomeZipDescriptor(String name, int version, boolean chrNamesAltered, String id, String cytoBandFileName, String geneFileName, String geneTrackName, String sequenceLocation, ZipFile genomeZipFile, Map<String, ZipEntry> zipEntries, boolean userDefined, boolean chromosomesAreOrdered) {
        super(name, version, chrNamesAltered, id, cytoBandFileName, geneFileName, geneTrackName, sequenceLocation, chromosomesAreOrdered);
        this.zipEntries = zipEntries;
        this.genomeZipFile = genomeZipFile;
        this.userDefined = userDefined;
    }

    @Override
    public InputStream getCytoBandStream() throws IOException {
        String fileName = this.cytoBandFileName;
        if (fileName == null) {
            return null;
        }
        return this.genomeZipFile.getInputStream(this.zipEntries.get(fileName));
    }

    @Override
    public InputStream getGeneStream() throws IOException {
        if (this.geneFileName == null) {
            return null;
        }
        return this.genomeZipFile.getInputStream(this.zipEntries.get(this.geneFileName));
    }

    @Override
    public boolean isUserDefined() {
        return this.userDefined;
    }
}

