/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.log4j.Logger;
import org.broad.igv.feature.AbstractFeatureParser;
import org.broad.igv.feature.Feature;
import org.broad.igv.feature.FeatureParser;
import org.broad.igv.feature.Genome;
import org.broad.igv.feature.GenomeDescriptor;
import org.broad.igv.feature.GenomeManager;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.AsciiLineReader;
import org.broad.igv.util.ResourceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneManager {
    private static Logger log = Logger.getLogger(GeneManager.class);
    private Genome genome;
    Map<String, List<Feature>> chromosomeGeneMap;
    String geneTrackName;
    Map<String, Feature> geneMap;
    Map<String, Integer> maxLocationMap;
    Map<String, Feature> longestGeneMap;
    private TrackProperties trackProperties;
    static Map<String, GeneManager> geneManagerCache = new HashMap<String, GeneManager>();

    public GeneManager(String genomeId) {
        this(genomeId, "Gene");
    }

    public GeneManager(String genomeId, String geneTrackName) {
        this.genome = GenomeManager.getInstance().getGenome(genomeId);
        if (this.genome == null) {
            throw new RuntimeException("Unknown genome: " + genomeId);
        }
        this.chromosomeGeneMap = new HashMap<String, List<Feature>>();
        this.geneMap = new HashMap<String, Feature>();
        this.maxLocationMap = new HashMap<String, Integer>();
        this.longestGeneMap = new HashMap<String, Feature>();
        this.geneTrackName = geneTrackName;
    }

    public String getGeneTrackName() {
        return this.geneTrackName;
    }

    public void addGene(Feature gene) {
        String chr;
        List<Feature> geneDataList;
        if (this.genome != null && this.genome.getChromosome(gene.getChr()) == null) {
            return;
        }
        Feature currentGene = this.geneMap.get(gene.getName());
        if (gene.getIdentifier() != null) {
            this.geneMap.put(gene.getIdentifier().trim().toUpperCase(), gene);
        }
        if (currentGene == null) {
            if (gene.getName() != null) {
                this.geneMap.put(gene.getName().trim().toUpperCase(), gene);
            }
        } else {
            int w1 = currentGene.getEnd() - currentGene.getStart();
            int w2 = gene.getEnd() - gene.getStart();
            if (w2 > w1 && gene.getName() != null) {
                this.geneMap.put(gene.getName().trim().toUpperCase(), gene);
            }
        }
        if ((geneDataList = this.chromosomeGeneMap.get(chr = gene.getChr())) == null) {
            geneDataList = new ArrayList<Feature>();
            this.chromosomeGeneMap.put(chr, geneDataList);
            this.maxLocationMap.put(chr, gene.getEnd());
        }
        if (gene.getEnd() > this.maxLocationMap.get(chr)) {
            this.maxLocationMap.put(chr, gene.getEnd());
        }
        if (this.longestGeneMap.get(chr) == null) {
            this.longestGeneMap.put(chr, gene);
        } else if (gene.getLength() > this.longestGeneMap.get(chr).getLength()) {
            this.longestGeneMap.put(chr, gene);
        }
        geneDataList.add(gene);
    }

    public Feature getGene(String geneName) {
        return this.geneMap.get(geneName.toUpperCase());
    }

    public int getLongestGeneLength(String chr) {
        Feature longestGene = this.longestGeneMap.get(chr);
        return longestGene == null ? 1000000 : longestGene.getLength();
    }

    public Map<String, List<Feature>> getChromsomeGeneMap() {
        return this.chromosomeGeneMap;
    }

    public List<Feature> getGenesForChromosome(String chromosome) {
        List<Feature> genes = this.chromosomeGeneMap.get(chromosome);
        if (genes == null) {
            log.info("No genes found for chromosome: " + chromosome);
        }
        return genes;
    }

    public Collection<String> getChromosomes() {
        return this.chromosomeGeneMap.keySet();
    }

    public List<Feature> getGenesForRegion(String chromosome, int start, int end) {
        ArrayList<Feature> geneList = new ArrayList<Feature>();
        for (Feature gene : this.getGenesForChromosome(chromosome)) {
            if (gene.getEnd() < start || gene.getStart() > end) continue;
            geneList.add(gene);
        }
        return geneList;
    }

    public void sortGeneLists() {
        Comparator c2 = new Comparator(){

            public int compare(Object o1, Object o2) {
                Feature g1 = (Feature)o1;
                Feature g2 = (Feature)o2;
                return g1.getStart() - g2.getStart();
            }
        };
        for (List<Feature> geneList : this.chromosomeGeneMap.values()) {
            Collections.sort(geneList, c2);
        }
    }

    public int getMaximumLocation(String chr) {
        return this.maxLocationMap.get(chr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized GeneManager getGeneManager(String genomeId) {
        AsciiLineReader reader;
        GenomeDescriptor genomeDescriptor;
        GeneManager geneManager = geneManagerCache.get(genomeId);
        if (geneManager == null && (genomeDescriptor = GenomeManager.getInstance().getGenomeDescriptor(genomeId)) != null && (reader = GeneManager.getGeneReader(genomeDescriptor)) != null) {
            try {
                geneManager = new GeneManager(genomeId, genomeDescriptor.getGeneTrackName());
                String geneFilename = genomeDescriptor.getGeneFileName();
                FeatureParser parser = AbstractFeatureParser.getInstanceFor(new ResourceLocator(geneFilename));
                if (parser == null) {
                    MessageUtils.showMessage("ERROR: Unrecognized annotation file format: " + geneFilename + "<br>Annotations for genome: " + genomeId + " will not be loaded.");
                } else {
                    List<Feature> genes = parser.loadFeatures(reader);
                    for (Feature gene : genes) {
                        geneManager.addGene(gene);
                    }
                    geneManager.sortGeneLists();
                    geneManager.trackProperties = parser.getTrackProperties();
                }
                geneManagerCache.put(genomeId, geneManager);
            }
            catch (Exception e2) {
                log.error("Error loading geneManager", e2);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        return geneManager;
    }

    private static AsciiLineReader getGeneReader(GenomeDescriptor genomeDescriptor) {
        FilterInputStream is = null;
        try {
            InputStream inputStream = genomeDescriptor.getGeneStream();
            if (inputStream == null) {
                return null;
            }
            AsciiLineReader reader = null;
            if (genomeDescriptor.isGeneFileGZipFormat()) {
                is = new GZIPInputStream(inputStream);
                reader = new AsciiLineReader(is);
            } else {
                is = new BufferedInputStream(inputStream);
                reader = new AsciiLineReader(is);
            }
            return reader;
        }
        catch (IOException ex) {
            log.warn("Error loading the genome!", ex);
            return null;
        }
    }

    public static boolean isValid(File file) {
        try {
            if (file == null || !file.exists() || file.length() < 1L) {
                return false;
            }
            AsciiLineReader reader = new AsciiLineReader(new FileInputStream(file));
            return GeneManager.isValid(reader, file.getName());
        }
        catch (Exception e2) {
            return false;
        }
    }

    public static boolean isValid(AsciiLineReader reader, String geneFilename) {
        if (reader != null) {
            try {
                FeatureParser parser = AbstractFeatureParser.getInstanceFor(new ResourceLocator(geneFilename));
                List<Feature> features = parser.loadFeatures(reader);
                if (features != null && !features.isEmpty()) {
                    return true;
                }
            }
            catch (Exception e2) {
                log.error("Invalid Gene file data : file=" + geneFilename, e2);
            }
        }
        return false;
    }

    public TrackProperties getTrackProperties() {
        return this.trackProperties;
    }
}

