/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import org.broad.igv.feature.AbstractFeature;
import org.broad.igv.feature.AminoAcidManager;
import org.broad.igv.feature.AminoAcidSequence;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.Strand;
import org.broad.igv.session.ViewContext;
import org.broad.igv.track.WindowFunction;

public class Exon
extends AbstractFeature {
    private int number;
    private int readingFrame = -1;
    private int codingStart;
    private int codingEnd;
    private AminoAcidSequence aminoAcidSequence;
    boolean utr = false;
    private int mrnaBase = -1;

    public void setMrnaBase(int base) {
        this.mrnaBase = base;
    }

    public int getAminoAcidNumber(int genomeCoordinate) {
        if (this.mrnaBase < 0) {
            return -1;
        }
        if (genomeCoordinate < this.getStart() || genomeCoordinate > this.getEnd()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.getStrand() == Strand.POSITIVE) {
            int mrnaCoord = this.mrnaBase + (genomeCoordinate - this.codingStart) - 1;
            return mrnaCoord < 0 ? -1 : mrnaCoord / 3 + 1;
        }
        if (this.getStrand() == Strand.NEGATIVE) {
            int mrnaCoord = this.mrnaBase + (this.codingEnd - genomeCoordinate);
            return mrnaCoord < 0 ? -1 : mrnaCoord / 3 + 1;
        }
        return 0;
    }

    public Exon(String chr, int start, int end, Strand strand) {
        super(chr, start, end, strand);
        this.codingStart = start;
        this.codingEnd = end;
    }

    public void setUTR(boolean utr) {
        this.utr = utr;
        this.codingStart = this.getStrand() == Strand.POSITIVE ? (this.codingEnd = this.getEnd()) : (this.codingEnd = this.getStart());
    }

    public void setCodingStart(int codingStart) {
        this.codingStart = Math.max(this.getStart(), codingStart);
    }

    public void setCodingEnd(int codingEnd) {
        this.codingEnd = Math.min(this.getEnd(), codingEnd);
    }

    public void setReadingFrame(int offset) {
        this.readingFrame = offset;
    }

    public void setPhase(int phase) {
        if (this.getStrand() == Strand.POSITIVE) {
            this.readingFrame = phase;
        } else if (this.getStrand() == Strand.NEGATIVE) {
            int modLen;
            this.readingFrame = modLen = (this.getCodingLength() - phase) % 3;
        }
    }

    public int getCdStart() {
        return this.codingStart;
    }

    public int getCdEnd() {
        return this.codingEnd;
    }

    public int getCodingLength() {
        return this.utr ? 0 : Math.max(0, this.codingEnd - this.codingStart);
    }

    public int getReadingShift() {
        return this.readingFrame;
    }

    public AminoAcidSequence getAminoAcidSequence() {
        if (this.aminoAcidSequence == null) {
            this.computeAminoAcidSequence();
        }
        return this.aminoAcidSequence;
    }

    public void setAminoAcidSequence(AminoAcidSequence aminoAcidSequence) {
        this.aminoAcidSequence = aminoAcidSequence;
    }

    private void computeAminoAcidSequence() {
        if (this.utr) {
            return;
        }
        int start = this.getStart();
        int end = this.getEnd();
        String chr = this.getChr();
        if (this.readingFrame >= 0) {
            int readStart = this.codingStart > start ? this.codingStart : start + this.readingFrame;
            int readEnd = Math.min(end, this.codingEnd);
            if (readEnd > readStart + 3) {
                String genome = ViewContext.getInstance().getGenomeId();
                this.aminoAcidSequence = AminoAcidManager.getAminoAcidSequence(genome, chr, readStart, readEnd, this.getStrand());
            }
        }
    }

    public LocusScore copy() {
        Exon copy = new Exon(this.getChr(), this.getStart(), this.getEnd(), this.getStrand());
        copy.aminoAcidSequence = this.aminoAcidSequence;
        copy.codingEnd = this.codingEnd;
        copy.codingStart = this.codingStart;
        return copy;
    }

    public String getValueString(double position, WindowFunction windowFunction) {
        String msg = this.number > 0 ? "Exon number: " + this.number : "";
        int aaNumber = this.getAminoAcidNumber((int)position);
        if (aaNumber > 0) {
            msg = msg + "<br>Amino acid number: " + aaNumber;
        }
        if (this.description != null) {
            msg = msg + this.description;
        }
        return msg;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public String getURL() {
        return null;
    }

    public boolean isUTR() {
        return this.utr;
    }
}

