/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.seg;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.data.seg.SegmentedBinaryReader;
import org.broad.igv.data.seg.SegmentedChromosomeData;
import org.broad.igv.util.IGVHttpUtils;
import org.broad.igv.util.ResourceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SegmentedBinaryRemoteReader
implements SegmentedBinaryReader {
    static Logger log = Logger.getLogger(SegmentedBinaryRemoteReader.class);
    String serverURL;
    String filePath;
    Map<String, String> attributes;

    public SegmentedBinaryRemoteReader(ResourceLocator locator) {
        this.serverURL = locator.getServerURL();
        this.filePath = locator.getPath();
    }

    @Override
    public SegmentedChromosomeData getChromosomeData(String chr) {
        InputStream is = null;
        try {
            URL url = new URL(this.serverURL + "?method=getChromosomeData&file=" + this.filePath + "&chr=" + chr);
            is = IGVHttpUtils.openConnectionStream(url);
            SegmentedChromosomeData cd = new SegmentedChromosomeData();
            cd.deserialize(is);
            SegmentedChromosomeData segmentedChromosomeData = cd;
            return segmentedChromosomeData;
        }
        catch (IOException ex) {
            log.error("Error opening file", ex);
            throw new RuntimeException(ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {
                    log.error("Error closing URL stream", iOException);
                }
            }
        }
    }

    @Override
    public List<String> getSampleNames() {
        InputStream urlStream = null;
        try {
            ArrayList<String> childNames = new ArrayList<String>(100);
            URL url = new URL(this.serverURL + "?method=getSampleNames&file=" + this.filePath);
            urlStream = IGVHttpUtils.openConnectionStream(url);
            BufferedReader reader = new BufferedReader(new InputStreamReader(urlStream));
            String nextLine = "";
            while ((nextLine = reader.readLine()) != null) {
                childNames.add(nextLine.trim());
            }
            reader.close();
            ArrayList<String> arrayList = childNames;
            return arrayList;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (urlStream != null) {
                try {
                    urlStream.close();
                }
                catch (IOException iOException) {
                    log.error("Error closing URL stream", iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getStringAttribute(String key) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
            InputStream urlStream = null;
            try {
                URL url = new URL(this.serverURL + "?method=getAttributes&file=" + this.filePath);
                urlStream = IGVHttpUtils.openConnectionStream(url);
                BufferedReader reader = new BufferedReader(new InputStreamReader(urlStream));
                String nextLine = "";
                while ((nextLine = reader.readLine()) != null) {
                    String[] tokens = nextLine.split("=");
                    if (tokens.length <= 1) continue;
                    this.attributes.put(tokens[0], tokens[1]);
                }
                reader.close();
            }
            catch (IOException ex) {
                log.error("Error in getChildNames", ex);
            }
            finally {
                if (urlStream != null) {
                    try {
                        urlStream.close();
                    }
                    catch (IOException iOException) {
                        log.error("Error closing URL stream", iOException);
                    }
                }
            }
        }
        return this.attributes.get(key);
    }
}

